import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
from myFunctions2 import * #Own functions


###########################################################################
# Function to open or close the log file
###########################################################################
def StartLogfile(interval):       
    #if not on the N900, use another place for the log file 
    if(data.demo==1): data.logfolder=data.devlogfolder #folder on devel PC
    
    print "Logfolder:",  data.logfolder
    try:
        os.mkdir(data.logfolder)
    except:
        print "Failed to create logfolder!"
        
#    print "Get IMEI number..."
#    if(data.demo==0):
#        x = os.popen('run-standalone.sh dbus-send --system --print-reply --type=method_call --dest=com.nokia.phone.SIM /com/nokia/phone/SIM/security Phone.Sim.Security.get_imei').read()
#        x2=string.split(x, "\"")
#        imei=x2[1]
#        ID=imei[10:]
#    else: ID="00000"    
    
    #open file, write header
    data.StartTime=time.localtime()
    data.StartTimeSec=time.mktime(data.StartTime)
    t=strftime("%Y-%m-%d_%H-%M-%S", data.StartTime)
    data.logfilename="SleepAnalyser_"+t+".csv"
    data.logfile = open(data.logfolder+data.logfilename, 'w')
    print "Created logfile "+data.logfilename
    t="Time, AccX, AccY, "
    d=strftime("%d-%m-%Y", data.StartTime)
    data.logfile.write(t+"User: "+data.user+", SW version: "+data.version+", Date: " + d + \
            ", Sampling interval: " + str(interval)+" ms, sampling smoothing: " +str(data.sample_smoothing)+ \
            ", value_smoothing: " + str(data.sample_smoothing )+"\n") #Print file header
    data.logfile.write("Note: \n")








###########################################################################
#  Write data into file, so it can be used in other tools
###########################################################################
def WriteIntoLogFile():
    d=str(data.arrData[0][data.arrDataIndex]) + ", " +  \
        str(data.arrData[1][data.arrDataIndex]) + ", " +  \
        str(data.arrData[2][data.arrDataIndex])

    data.logfile.write(d+"\n")
    if(data.debug==1): print d



###########################################################################
#  Close log file
###########################################################################
def StopLogfile():
    data.logfile.close()



###########################################################################
#  Load list of log files into array
###########################################################################
def LoadFileList():
    Show_passed_time("LoadFileList Start")
    print "Load file list"
    output = os.popen("cd "+data.logfolder+"; ls -C1 *.csv").read() # run ls and make the output look like a file I can read
    data.arrLogFiles=output.split("\n")
    data.arrLogFiles.pop()
    print data.arrLogFiles
    if(data.logfilename>""):
        print data.logfilename
        data.arrLogFileIndex=0
        for i in range(len(data.arrLogFiles)):
            if(data.logfilename==data.arrLogFiles[i]): data.arrLogFileIndex=i
            
    Show_passed_time("LoadFileList End")






###########################################################################
#  Load log file  to read and visualise it
###########################################################################
def OpenLogFile():    
    Show_passed_time("OpenLogFile Start")
    file = open(data.logfolder+data.logfilename, 'r')
    data.arrDataIndex=0
    print "Open logfile",  data.logfilename
    try:
        data.Header=file.readline()
        print "Header:",  data.Header
        h=string.split(data.Header, ", ")
        v=h[4]
        SWversion=string.replace(v, "SW version:",  "")
        try:
            fl=float(SWversion)
        except:
            print "SW Version format not valid:",  SWversion
            fl=0.0
#        print v,  fl,  data.version
        if(fl>1.1 and fl!=213.1321): #log files newer than SW version 1.1. and not Demo version have a new line with notes
#            print "SW version > 1.1, contains Note"
            data.Note=file.readline()
            data.Note=string.replace(data.Note, "Note: ",  "")
            data.Note=string.replace(data.Note, "\n",  "")
        else:
            data.Note=""
            data.Header=string.replace(data.Header,  v,  "SW version: "+str(data.version))
#            print "New header:",  data.Header
        print "Note:",  data.Note
            
        
        for line in file:
            d=string.split(line,  ", ")
            data.arrData[0][data.arrDataIndex]=d[0] #time
            data.arrData[1][data.arrDataIndex]=int(d[1]) #X
            data.arrData[2][data.arrDataIndex]=int(d[2]) #Y
            data.arrDataIndex=data.arrDataIndex+1            
#            if(data.arrDataIndex==data.arrDataLen): 
#                print "Stopped, array is full, file is to big"
#                break
    finally:
        file.close()
    
    print "Loaded",  str(data.arrDataIndex),  "lines"
    Show_passed_time("OpenLogFile End")
    
    
    
    
###########################################################################
#  Load log file  to change Note (on line 2)
###########################################################################
def ChangeNoteInFile():    
    file = open(data.logfolder+data.logfilename, 'w')
    print "Open logfile",  data.logfilename
    print "Change Note to\"",  data.Note,  "\" in file",  data.logfilename
   
   
    file.write(data.Header)
    file.write("Note: "+data.Note+"\n")
    for i in range(0,  data.arrDataIndex):
        d=str(data.arrData[0][i]) + ", " + str(data.arrData[1][i]) + ", " +  str(data.arrData[2][i])
        file.write(d+"\n")
    file.close()
    print "Wrote",  i +1,  "lines into file"
    
    
    
    
###########################################################################
# Load the configuration from the config file
###########################################################################
def LoadConfig():    
    #get configuration
    print "Configuration file:",  data.configfolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
#    if os.path.exists(data.configfolder+data.ConfigFile):
    try:
        config.read(data.configfolder+data.ConfigFile)
        
        data.sampling = config.getint('main', 'sampling')
        data.sample_smoothing = config.getint('main', 'sample_smoothing')
        data.value_smoothing = config.getint('main', 'value_smoothing')
        data.trigger = config.getint('main', 'trigger')
        data.derivation = config.getint('main', 'derivation')
        data.Ysize = config.getint('main', 'Ysize')
        data.Xscale = config.getint('main', 'Xscale')
        data.Yscale = config.getint('main', 'Yscale')
        data.user = config.get('main', 'user')
        data.lastlogfile = config.get('main', 'lastlogfile')
        print "Configuration loaded ("+data.ConfigFile+")"
#    else:
    except: #use default config
        print data.configfolder+data.ConfigFile + " not existing, using default parameters..."
        try:
            config.add_section('main')
        except:
            pass
        config.set('main', 'sampling', str(data.sampling))
        config.set('main', 'sample_smoothing', str(data.sample_smoothing))      
        config.set('main', 'value_smoothing', str(data.value_smoothing))      
        config.set('main', 'trigger', str(data.trigger))      
        config.set('main', 'derivation', str(data.derivation))      
        config.set('main', 'Ysize', str(data.Ysize))      
        config.set('main', 'Xscale', str(data.Xscale))     
        config.set('main', 'Yscale', str(data.Yscale))      
        config.set('main', 'user', str(data.user))      
        config.set('main', 'lastlogfile', str(data.lastlogfile))      

    
    #print usefull data
    print "SW version:", data.version
#    print "Sampling interval:", data.sampling, "ms"
#    print "sample_smoothing:", data.sample_smoothing, "x"
#    print "value_smoothing:", data.value_smoothing, "x"
#    print "=> log interval:", data.sampling*data.value_smoothing/1000, "s"
#    print "Derivation:", data.derivation, "(substracts value", data.derivation, "- value 0)"  
#    print "Trigger level:", data.trigger
    print "Yscale (for graph only):",  data.Yscale

    return config



###########################################################################
# Write the configuration into the config file
###########################################################################
def WriteConfig(config):
        f=data.configfolder+data.ConfigFile
        print "Save configuration ("+f+")"
        if (not os.path.exists(data.configfolder)):
            print "Create configuration folder: ",  data.configfolder
            os.mkdir(data.configfolder)
        try:
            data.configfile = open(f, 'w')
            config.write(data.configfile)
            print "Configuration saved"
        except:
            print "Failed to write configuration file!"
    
    
    
    
    
    

