#!/usr/bin/env python
###########################################################################
# Name: 	         SleepAnalyser
# Description:	 Analyses your movement during your sleep
# Copyright:     George Ruinelli, george@ruinelli.ch
# Last change:  (See file "version")
# Licence:         GPL
###########################################################################

import sys
import random
import time
from time import strftime
import math
import array
import string

from PyQt4.QtCore import * 
from PyQt4.QtGui import * 

import ConfigParser
import os, os.path



import data #own data
from myFunctions import * #Own functions
#from myMP3 import * #Own functions to play an MP3

#GUIs
from Ui_StartWindow import *
from Ui_CollectingWindow import *
from Ui_LogWindow import *
from Ui_NoteWindow import *



  
###########################################################################
# Main function
###########################################################################
def main():
    global app,  StartWindow,  CollectingWindow,  LogWindow ,  NoteWindow
    global config
    global CollectingWindowGraph
   
    try:
        if(sys.argv[1]=="debug"): 
            print "Enable Debug mode"
            data.debug=1
    except:
        data.debug=0

    #if not on the N900, a acceleration sensor has to be simulated
#    uname=os.uname()
#    if(uname[1]=="Nokia-N900"): data.demo=0	#runs on real N900 hardware
    if os.path.exists("/sys/class/i2c-adapter/i2c-3/3-001d/coord"): data.demo=0	#runs on real N900 hardware
    else: data.demo=1	#runs on other hardware/OS


    if(data.demo==1):
        print "Runs not on a N900 => Use randomizer for acceleration sensor data"
        data.configfolder=data.devconfigfolder
        data.logfolder=data.devlogfolder

    app = QtGui.QApplication(sys.argv)
    
    config=LoadConfig()
    
    data.app_path=os.path.dirname(__file__)
    if(data.app_path==""): data.app_path="./"
    else: data.app_path=data.app_path+"/"
    
    StartWindow = frmStartWindow()    
    CollectingWindow = frmCollectingWindow()
    LogWindow = frmLogWindow()
    NoteWindow = frmNoteWindow()
    
    StartWindow.show()      
#    ShowLogWindow()


    StartWindow.UpdateScreenStart()
    StartWindow.show()
    
    #get user name for in log files
    if(data.user==""):
#            tmp= QFileDialog.getOpenFileName(None,"Open SleepCycle Log File", data.logfolder, "Log Files (*.csv)");
        text = QInputDialog.getText(None, "SleepAnalyser", "Please enter your name.\n"+ \
                                                                                             "It will be used in the records file, this makes it easier\n" + \
                                                                                             "when you want to share your sleep pattern with others.")
        if(text != ""):
            data.user=text[0]
            config.set('main', 'user', str(data.user))    
        else:
            pass
    print "User name:",  data.user

    sys.exit(app.exec_())







###########################################################################
#  Gets called every second,
###########################################################################
def TimerLoop():
    global CollectingWindowGraph
    
#    Show_passed_time("TimerLoop start")

    r=GetSensorData() #(interval: sampling*sample_smoothing*value_smoothing)
    if(r==1):
        WriteIntoLogFile()
        ProcessData() 
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        CollectingWindowGraph.update() #show CollectingWindowGraph    
    
    CollectingWindow.UpdateScreen()    
    
#    Show_passed_time("TimerLoop end")

  
  
  
  
###########################################################################
# Show the collectring window (hera the data gets visualised during the logging)
###########################################################################
def ShowCollectingWindow():
    CollectingWindow.show()
    StartWindow.hide()
    data.Mode=0 #run in normal mode
    ToggleMeasurement()
    
    
###########################################################################
# Show the collectring window (hera the data gets visualised during the logging)
###########################################################################
def ShowCollectingWindowTest():
    CollectingWindow.show()
    StartWindow.hide()
    data.Mode=1 #run in quick mode (for testing only)
    ToggleMeasurement()
    data.Xscale=0 #default zoom level
    data.test=1 #hide axis lables
    
    
  
###########################################################################
# Show the log window (her ethe data from a file gets visualised)
###########################################################################
def ShowLogWindow():
    global LogWindowGraph
    
    tmp= QFileDialog.getOpenFileName(None,"Open SleepCycle Log File", data.logfolder, "Log Files (*.csv)");
    tmp2=tmp.split("/")
    l=len(tmp2)    
    x=tmp2[l-1]
    if(x==""): return #only continue if valid log file selected
    data.logfilename=x
    
    LogWindowGraph = LogWindowCanvas()
#    data.Xscale=1 #default zoom level
#    LogWindowGraph.show()
    ShowLogFile()
    
    LogWindow.show()
    StartWindow.hide()



############################################################################
## Stretch graph to show more details
############################################################################
def ZoomIn():
    if(data.Xscale==0): return
    LogWindow.ui.bZoomOut.setEnabled(True)
    if(data.Xscale==1): LogWindow.ui.bZoomIn.setEnabled(False)
    else: LogWindow.ui.bZoomIn.setEnabled(True)
    data.Xscale=(data.Xscale-1) % data.arrXscaleLen
    ProcessData()
    Show_passed_time("## ZoomIn")
    data.ChangesInGraph=1 #Make sure it only gets refreshed once
    CollectingWindow.update()
    LogWindow.update()

def ZoomOut():
    if(data.Xscale==data.arrXscaleLen-1): return
    LogWindow.ui.bZoomIn.setEnabled(True)
    if(data.Xscale==data.arrXscaleLen-2): LogWindow.ui.bZoomOut.setEnabled(False)
    else: LogWindow.ui.bZoomOut.setEnabled(True)
    data.Xscale=(data.Xscale+1) % data.arrXscaleLen
    ProcessData()
    Show_passed_time("## ZoomIn")
    data.ChangesInGraph=1 #Make sure it only gets refreshed once
    CollectingWindow.update()
    LogWindow.update()





###########################################################################
# Starte the measurement
###########################################################################
def StartMeasurement(interval):
    global CollectingWindowGraph
    global app
    
    #init value
    data.sample_index=0
    data.values_total=0
    data.arrDataIndex=0
    
    StartLogfile(interval)
        
    CollectingWindowGraph = CollectingWindowCanvas()
    data.Xscale=1 #default zoom level
    CollectingWindowGraph.show()
    
    print "Start timers (Interval:", interval ,"ms)..."
    print "Sampling interval:", interval, "ms"
    print "sample_smoothing:", data.sample_smoothing, "x"
    print "value_smoothing:", data.value_smoothing, "x"
    print "=> log interval:", interval*data.value_smoothing, "ms"
    print "Derivation:", data.derivation, "(substracts value", data.derivation, "- value 0)"  
    
    app.timer_GetData = QtCore.QTimer()
    QtCore.QObject.connect(app.timer_GetData, QtCore.SIGNAL("timeout()"), TimerLoop)        
    app.timer_GetData.start(interval)
    data.run=1
    
    CollectingWindow.UpdateScreenStart()
    



###########################################################################
# Stop the measurement
###########################################################################
def ToggleMeasurement():
    global app
    if(data.run==0): #not running
        data.run=1
        print "data.Mode:",  data.Mode,  data.sampling
        if(data.Mode==0):
            StartMeasurement(data.sampling) #normal
        else:  
            StartMeasurement(10) #Fast mode for testing
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
    else: #running
        data.run=0
        print "Stop timers..."
        app.timer_GetData.stop()
        data.run=0
        StopLogfile()       
        CollectingWindow.UpdateScreenStop()
        data.test=0 # reset test mode if was active
    
    




###########################################################################
# Raise the trigger in the graph + sleep phases
###########################################################################
def RaiseTrigger():   
    data.trigger=data.trigger+1
    if(data.trigger>100): data.trigger=100
    ProcessData()
    data.ChangesInGraph=1 #Make sure it only gets refreshed once
    CollectingWindow.update()
    CollectingWindow.UpdateScreen()
    LogWindow.update() 
    LogWindow.UpdateScreen()
    
   
   

###########################################################################
# Lower the trigger in the graph + sleep phases
###########################################################################
def LowerTrigger():   
    data.trigger=data.trigger-1
    if(data.trigger<0): data.trigger=0
    ProcessData()
    data.ChangesInGraph=1 #Make sure it only gets refreshed once
    CollectingWindow.update()
    CollectingWindow.UpdateScreen()
    LogWindow.update()
    LogWindow.UpdateScreen()
   
   
   
   
   
   

###########################################################################
# Show (refreshs) the graph.
# the parameter indcates on which window it will be drawn
###########################################################################
def showGraph(self):
        Show_passed_time("showGraph Start")
        if(data.ChangesInGraph==0): 
            if(data.debug==1): print "------>         Do not redraw, nothing changed!"
            return 
            
        data.ChangesInGraph=0
        paint = QtGui.QPainter()
        paint.begin(self)

        paint.setFont(QtGui.QFont('Decorative', 12))
        paint.setPen(QtGui.QColor("gray"))
        paint.setBrush(QtGui.QColor("black"))

        #show CollectingWindowGraph border
        paint.drawRect(0,0,781,data.Ysize)           

        Xscale=data.arrXscale[data.Xscale]
#        print "Zoom level:",  data.Xscale

        x=data.arrDataIndex/Xscale
        if(x>775): 
            shift=(x-775)*Xscale
#            print "Curve too long,  dropping first",  shift,  "values"
        else: shift=0
            
        try:
            t=string.split(data.arrData[0][shift], ":")
            h0=int(t[0])
            m0=int(t[1])
        except:
            h0=int(strftime("%H", time.localtime()))
            m0=int(strftime("%M", time.localtime()))
#        print "Start time of graph:",  h0,  m0

        
        
        
        #draw Xscale
        paint.setPen(QtGui.QColor("white"))
        
        #decade:
        #6 => 60px/h
        #1 => 360px/h
        decade=360/Xscale
        minutestonexthour=60-m0
        offset=minutestonexthour*decade/60
        
        
        Show_passed_time("2")
        
        #main lines + text
        if(data.test==0):
            for i in range(0, 781+decade,  decade):
                paint.drawLine(i+offset, data.Ysize, i+offset, data.Ysize+10)  
                for k in range(1, 6):
                    x=i+offset+k*decade/6-decade
                    paint.drawLine(x, data.Ysize, x, data.Ysize+5)  
                h=(h0+int(i/decade)+1) % 24
                paint.drawText(i+offset-20, data.Ysize+30, str(h)+":00") 
        else: #test mode, do not show X scale as it is wrong
            paint.drawText(200, data.Ysize+20, "Test Mode")


        #trigger line
        y=(data.Ysize-(data.trigger*data.Yscale))-2
        paint.drawLine(1, y-15, 781, y-15)  


        Show_passed_time("4")

        #draw graph
        lastmove=0
#        print shift,  data.arrDataIndex-data.derivation,  Xscale
        
        end=data.arrDataIndex-shift-data.derivation
        for i in range(0,  end,  Xscale):
            k=i+shift
            
            
            
            #when Xscale is small, we have to merge several records into 1 pixel.
            #To not miss any movement, we use the biggest movement of the merged records:
            peak=0            
            paint.setPen(QtGui.QColor("yellow"))
            for j in range(0, Xscale):
#                Show_passed_time("L 1")
                p=abs(data.arrData[3][k])+abs(data.arrData[4][k])
                if(p>peak): peak=p
           
            
            
            
#            if(1): #one or more movement for this pixel
#                peak=abs(data.arrData[3][k])+abs(data.arrData[4][k])
            Y=peak*data.Yscale
            #Draw movement line
#            paint.setBrush(QtGui.QColor("yellow"))
            paint.drawLine(i/Xscale, data.Ysize-Y-1-15, i/Xscale, data.Ysize-1-15)  
            
            
            #fill space between yellow movement lines
#                if(k>lastmove+1):k
#            print i,  end,  Xscale
            if(peak>data.trigger or i>=end-Xscale):
                
#                if(data.Mode==1): #quick mode for testing
#                    playMP3() #make beep for testing
                
#                Show_passed_time("L 2")
##                    1=10 sec
#                    if((i-lastmove)>30*Xscale): color="#009100" #green
#                    elif((i-lastmove)>15*Xscale): color="#005000" #dark green
#                    t=(i-lastmove)*Xscale
#                    print t,  30*Xscale
#                    if(t>30): color="#009100" #green
#                    elif(t>15): color="#005000" #dark green
#                    else: color="#6D0000" #dark red 

                x0=lastmove/Xscale+1
                x1=i/Xscale-1
                if(x0<x1):
                    t=(x1-x0)*Xscale/6          
#                        print x0,  "<=>",  x1,  t,  Xscale
                    if(t>30): color="#009100" #green
                    elif(t>15): color="#005000" #dark green
                    else: color="#6D0000" #dark red                         
                    paint.setBrush(QtGui.QColor(color))
                    paint.setPen(QtGui.QColor(color))
                    paint.drawRect(x0, data.Ysize-11, x1-x0, 10)                     
                    paint.setPen(QtGui.QColor("yellow"))
#                        print "=     Draw field",  x0,  x1,  data.Ysize,  color
                lastmove=i

        Show_passed_time("showGraph End")





###########################################################################
# Delete an existing logfile
###########################################################################
def DeleteLogFile():
    LogWindow.DeleteLogFile()


def ShowLogFile():
    OpenLogFile()    
    ProcessData()
    LogWindow.UpdateScreen()
    LogWindowGraph = LogWindowCanvas()
    data.Xscale=1 #default zoom level
    data.ChangesInGraph=1 #Make sure it only gets refreshed once
    LogWindowGraph.show()

###########################################################################
# Load next  logfile
###########################################################################
def NextLogFile():
    LoadFileList(+1)
    ShowLogFile()


###########################################################################
# Load last logfile
###########################################################################
def LastLogFile():
    LoadFileList(-1)
    ShowLogFile()


###########################################################################
# Close the window Notes
###########################################################################
def NotesClose():
    StartWindow.show()
    NoteWindow.close()
    
    
###########################################################################
# Save the notes
###########################################################################
def NotesSave():
    NoteWindow.SaveNotes()
    NotesClose()






















###########################################################################
#  Class for Main Window
###########################################################################
class frmStartWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_StartWindow()
        self.ui.setupUi(self)

        QtCore.QObject.connect(self.ui.bCollecting, QtCore.SIGNAL("clicked()"), ShowCollectingWindow)
        QtCore.QObject.connect(self.ui.bLog, QtCore.SIGNAL("clicked()"), ShowLogWindow)
        QtCore.QObject.connect(self.ui.bQuick, QtCore.SIGNAL("clicked()"), ShowCollectingWindowTest)
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bSetAlarm.setIcon(QIcon(data.app_path+"SleepAnalyser.png"))
            self.ui.bQuick.setIcon(QIcon(data.app_path+"krec.png"))
            self.ui.bCollecting.setIcon(QIcon(data.app_path+"krec.png"))
            self.ui.bLog.setIcon(QIcon(data.app_path+"zoom.png"))

    def UpdateScreenStart(self):
        try:   
            print "Application path:",  data.app_path
            file = open(data.app_path+"version", 'r')
            data.version = file.readline()
            data.version=data.version[:-1]
            data.build = file.readline()
        except:
            print "Version file not found"
        self.ui.lblVersion.setText(data.version+"."+data.build)
        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"SleepAnalyser.png"))

    def closeEvent(self, event):
        global config
        WriteConfig(config)








###########################################################################
#  Class for Collecting Window
###########################################################################
class frmCollectingWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_CollectingWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bStop, QtCore.SIGNAL("clicked()"), ToggleMeasurement)
        QtCore.QObject.connect(self.ui.bRaiseTrigger, QtCore.SIGNAL("clicked()"), RaiseTrigger)
        QtCore.QObject.connect(self.ui.bLowerTrigger, QtCore.SIGNAL("clicked()"), LowerTrigger)
        QtCore.QObject.connect(self.ui.bZoomIn, QtCore.SIGNAL("clicked()"), ZoomIn)
        QtCore.QObject.connect(self.ui.bZoomOut, QtCore.SIGNAL("clicked()"), ZoomOut)
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bZoomIn.setIcon(QIcon(data.app_path+"zoom-in.png"))
            self.ui.bZoomOut.setIcon(QIcon(data.app_path+"zoom-out.png"))
            self.ui.bRaiseTrigger.setIcon(QIcon(data.app_path+"go-up.png"))
            self.ui.bLowerTrigger.setIcon(QIcon(data.app_path+"go-down.png"))
            

    def UpdateScreen(self):
        if(data.demo==0):
            self.ui.lblSamples_Taken.setText(str(data.values_total))
        else:
            self.ui.lblSamples_Taken.setText(str(data.values_total)+" (Demo Mode)")

        t=time.mktime(time.localtime())
        time_difference=t-data.StartTimeSec
        t=strftime("%H:%M:%S", time.gmtime(time_difference))
        self.ui.lblElapsedTime.setText(t)
            

    def UpdateScreenStart(self):
        self.ui.lblLogfile.setText(str(data.logfilename))
        t= t=strftime("%d. %b %Y %H:%M:%S", data.StartTime)
        self.ui.lblStarttime.setText(t)
        self.ui.lblSamples_Taken.setText("0")
        self.ui.lblElapsedTime.setText("00:00:00")
        self.ui.lblYscale.setText(str(data.Yscale))
        self.ui.lblTrigger.setText(str(data.trigger*data.Yscale))
        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"SleepAnalyser.png"))
        self.ui.bStop.setIcon(QIcon(data.app_path+"krec2.png"))
        self.ui.bStop.setText("Stop recording")
        
        
    def UpdateScreenStop(self):
        self.ui.lblSamples_Taken.setText(str(data.values_total)+" (Stopped)")
        self.ui.bStop.setIcon(QIcon(data.app_path+"krec.png"))
        self.ui.bStop.setText("Start recording")
        



    def closeEvent(self, event):
        #check if user wants to keep this record
        reply = QtGui.QMessageBox.question(self, 'Keep Logfile?', "Do you want to keep this Record?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.No:
            print "Delete logfile: "+data.logfilename
            os.remove(data.logfolder+data.logfilename)
            
        if(data.run==1): ToggleMeasurement()
        StartWindow.show()
#        NoteWindow.show()
        CollectingWindow.close() 


   
   






###########################################################################
# Class for Log Window
###########################################################################
class frmLogWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_LogWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bRaiseTrigger, QtCore.SIGNAL("clicked()"), RaiseTrigger)
        QtCore.QObject.connect(self.ui.bLowerTrigger, QtCore.SIGNAL("clicked()"), LowerTrigger)
        QtCore.QObject.connect(self.ui.bZoomIn, QtCore.SIGNAL("clicked()"), ZoomIn)
        QtCore.QObject.connect(self.ui.bZoomOut, QtCore.SIGNAL("clicked()"), ZoomOut)
        QtCore.QObject.connect(self.ui.bNext, QtCore.SIGNAL("clicked()"), NextLogFile)
        QtCore.QObject.connect(self.ui.bLast, QtCore.SIGNAL("clicked()"), LastLogFile)
        QtCore.QObject.connect(self.ui.bDelete, QtCore.SIGNAL("clicked()"), DeleteLogFile)
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bLast.setIcon(QIcon(data.app_path+"go-previous.png"))
            self.ui.bNext.setIcon(QIcon(data.app_path+"go-next.png"))
            self.ui.bDelete.setIcon(QIcon(data.app_path+"edittrash.png"))
            self.ui.bZoomIn.setIcon(QIcon(data.app_path+"zoom-in.png"))
            self.ui.bZoomOut.setIcon(QIcon(data.app_path+"zoom-out.png"))
            self.ui.bRaiseTrigger.setIcon(QIcon(data.app_path+"go-up.png"))
            self.ui.bLowerTrigger.setIcon(QIcon(data.app_path+"go-down.png"))
            
        self.ui.lblYscale.setText(str(data.Yscale))


    def UpdateScreen(self):
        self.ui.lblLogfile.setText(data.logfilename)
        self.ui.lblStarttime.setText(str(data.arrData[0][0]))
        self.ui.lblStoptime.setText(str(data.arrData[0][data.arrDataIndex-1]))
        self.ui.lblTrigger.setText(str(data.trigger*data.Yscale))
        self.ui.lblYscale.setText(str(data.Yscale))


    def DeleteLogFile(self):
        reply = QtGui.QMessageBox.question(self, 'Delete Logfile?', "Are you sure you want to delete this record?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.Yes:
            print "Delete logfile: "+data.logfilename
            os.remove(data.logfolder+data.logfilename)    
            data.arrLogFileIndex=(data.arrLogFileIndex+1)  % len(data.arrLogFiles)
            data.logfilename=data.arrLogFiles[data.arrLogFileIndex]
            ShowLogFile()



    def closeEvent(self, event):
#        self.ui.cZoom.setChecked(False)
#        Zoom()
        config.set('main', 'trigger', str(data.trigger))      
        LogWindow.close()
        StartWindow.show()











###########################################################################
# Class for Log Window
###########################################################################
class frmNoteWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_NoteWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bClose, QtCore.SIGNAL("clicked()"), NotesClose)
        QtCore.QObject.connect(self.ui.bSave, QtCore.SIGNAL("clicked()"), NotesSave)
        
        
    def SaveNotes(self):
        txt=""
        if(self.ui.cFeedback1.isChecked()==true):
            pass

    def closeEvent(self, event):
        NoteWindow.close()
        StartWindow.show()











###########################################################################
# Class for drawing the CollectingWindowGraph
###########################################################################
class CollectingWindowCanvas(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, CollectingWindow)    
        self.setGeometry(9, 180, 782, data.Ysize+30)
    
    def paintEvent(self, event):
        showGraph(self)





    
    
###########################################################################
# Class for drawing the LogWindowGraph
###########################################################################
class LogWindowCanvas(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, LogWindow)    
        self.setGeometry(9, 100, 782, data.Ysize+30)
    
    def paintEvent(self, event):
        showGraph(self)
    
    
    

    
    
    

###########################################################################
# Now we can start it.
main()

