import sys
import os
import random
#from PyQt4 import QtGui, QtCore
import time
from time import strftime
import math
import array
import string


import ConfigParser
import os, os.path


import data


###########################################################################
# Function to open or close the log file
###########################################################################
def StartLogfile():
       
    #if not on the N900, use another place for the log file 
    if(data.demo==1): data.logfolder=data.devlogfolder #folder on devel PC
    
    print "Logfolder:",  data.logfolder
    try:
        os.mkdir(data.logfolder)
    except:
        print "Failed to create logfolder!"
    
    #open file, write header
    data.StartTime=time.localtime()
    t=strftime("%Y-%b-%d_%H-%M-%S", data.StartTime)
    data.logfilename=data.logfolder+"SleepCycle_"+t+".csv"
    data.logfile = open(data.logfilename, 'w')
    print "Created logfile "+data.logfilename
    t="Date/Time, AccX, AccY"
    d=strftime("%d-%b-%Y", data.StartTime)
    data.logfile.write(t+", SW version: "+data.version+", Date: " + d + \
            ", Sampling intervall: " + str(data.sampling )+" ms, value_smoothing: " + \
            str(data.sample_smoothing )+"\n") #Print file header

    data.StartTimeSec=time.mktime(data.StartTime)







###########################################################################
#  Write data into file, so it can be used in other tools
###########################################################################
def WriteIntoLogFile():
    d=str(data.arraySensorData[0][data.SensorData_ArrayIndex]) + ", " +  \
        str(data.arraySensorData[1][data.SensorData_ArrayIndex]) + ", " +  \
        str(data.arraySensorData[2][data.SensorData_ArrayIndex])

    data.logfile.write(d+"\n")
    if(data.debug==1): print d



def StopLogfile():
    data.logfile.close()


###########################################################################
#  Load old log file  to read and visualise it
###########################################################################
def OpenLogFile():
    
#    data.logfilename=data.appfolder+"data/SleepCycle_15-Jun-2010_02-25-52.csv"
    file = open(data.logfilename, 'r')

    data.SensorData_ArrayIndex=0
    print "Open logfile",  data.logfilename
    try:
        header=file.readline()
        print "File data:",  header
        for line in file:
            d=string.split(line,  ", ")
            d[1]=int(d[1])
            d[2]=int(d[2])
#            print data
            data.arraySensorData[0][data.SensorData_ArrayIndex]=d[0] #time
            data.arraySensorData[1][data.SensorData_ArrayIndex]=d[1] #X
            data.arraySensorData[2][data.SensorData_ArrayIndex]=d[2] #Y
            data.SensorData_ArrayIndex=data.SensorData_ArrayIndex+1            
            if(data.SensorData_ArrayIndex==data.SensorData_ArrayLenght): 
                print "Stopped, array is full, file is to big"
                break
    finally:
        file.close()
    
    print "Loaded",  str(data.SensorData_ArrayIndex),  "lines"
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

###########################################################################
# 
###########################################################################
def ReadAccSensor():
    
    coords=[0, 0]
    
    if(data.demo==0):
        
        for i in range(data.sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
        
        coords[0]=coords[0] / data.sample_smoothing
        coords[1]=coords[1] / data.sample_smoothing
        
    else:
        coords[0]=int(random.uniform(-50,50))
        coords[1]=int(random.uniform(-50,50))

    return coords








###########################################################################
# 
###########################################################################
def GetSensorData():
    
    d=ReadAccSensor()
    data.arraySensorDataTemp[0]=data.arraySensorDataTemp[0]+d[0]
    data.arraySensorDataTemp[1]=data.arraySensorDataTemp[1]+d[1]

    data.sample_index=data.sample_index+1
    
    if(data.sample_index==data.value_smoothing): #if is 10 runs over        
        data.sample_index=0
        data.SensorData_ArrayIndex=data.values_total % data.SensorData_ArrayLenght
        data.values_total=data.values_total+1
        
        data.arraySensorData[0][data.SensorData_ArrayIndex]=strftime("%H:%M:%S", time.localtime())
        data.arraySensorData[1][data.SensorData_ArrayIndex]=data.arraySensorDataTemp[0]/data.value_smoothing
        data.arraySensorData[2][data.SensorData_ArrayIndex]=data.arraySensorDataTemp[1]/data.value_smoothing

        data.arraySensorDataTemp[0]=0
        data.arraySensorDataTemp[1]=0

#        print strftime("%H:%M:%S", time.localtime()),  SensorData_ArrayIndex,  arraySensorData[0][SensorData_ArrayIndex],  \
#        arraySensorData[1][SensorData_ArrayIndex],  arraySensorData[2][SensorData_ArrayIndex]

        return 1 #added new values to arraySensorData
     
    else: return 0












###########################################################################
#  Process data
###########################################################################
def ProcessData():
    DerivedData_ArrayLenght=4680 #(1 value/10sec for 13h), 6*13*60
    arrayDerivedData=[[0]*DerivedData_ArrayLenght,  [0]*DerivedData_ArrayLenght] #[0]=X, [1]=Y
       
    DerivedData_ArrayIndex=0
    entries=data.SensorData_ArrayIndex-5
    data.MovementData_ArrayUsage=entries/6
    
    
#    print "process data"
#    print data.arraySensorData
    
    #DERIVATION (ABLEITUNG)
    for i in range(0, entries):
#        print i,  data.arraySensorData[0][i] ,  data.arraySensorData[1][i],  data.arraySensorData[2][i]  
#        arrayDerivedData[0][i]=data.arraySensorData[0][i] #copy time 
        arrayDerivedData[0][i]=data.arraySensorData[1][i+5] - data.arraySensorData[1][i] #X  in 5 sec - X now
        arrayDerivedData[1][i]=data.arraySensorData[2][i+5] - data.arraySensorData[2][i] #Y  in 5 sec - Y now
        
#    DerivedData_ArrayIndex=data.SensorData_ArrayIndex-5

#        print i,  data.arraySensorData[1][i], data.arraySensorData[2][i], arrayDerivedData[1][i],  arrayDerivedData[2][i]



    for i in range(data.MovementData_ArrayLenght): data.arrayMovementdata[2][i]=0 #reset Movement
    for i in range(data.MovementData_ArrayLenght): data.arrayMovementdata[3][i]=0 #reset Movement


    if(data.zoom==0):
        #merge 6 values into one => 10sec=>1min
        lastmovement=0
        for i in range(0, entries/6):
            t=data.arraySensorData[0][i*6] #time
            t2=string.split(t, ":")
            data.arrayMovementdata[0][(i)]=int(t2[0]) #hours
            data.arrayMovementdata[1][(i)]=int(t2[1]) #minutes
            
            #filter bigger movement (if 1 or more of 6 are above threshold)
            for j in range(0, 6):
                data.arrayMovementdata[3][(i)]=lastmovement #note when lastmovement movement was
                if(abs(arrayDerivedData[0][i*6+j])+abs(arrayDerivedData[1][i*6+j])>data.trigger):  
                    data.arrayMovementdata[2][(i)]=1 #Movement
                    lastmovement=i
                    break
        
    else:  #show last 2 hours zoomed
        lastmovement=0
        for i in range(0,  720): #(60px*12)
            print i
            t=data.arraySensorData[0][entries-720+i] #time
            t2=string.split(t, ":")
            data.arrayMovementdata[0][(i)]=int(t2[0]) #hours
            data.arrayMovementdata[1][(i)]=int(t2[1]) #minutes
            
            #filter bigger movement (if 1 or more of 6 are above threshold)
            data.arrayMovementdata[3][(i)]=lastmovement #note when lastmovement movement was
            if(abs(arrayDerivedData[0][entries-720+i])+abs(arrayDerivedData[1][entries-720+i])>data.trigger):  
                data.arrayMovementdata[2][(i)]=1 #Movement
                lastmovement=i
 




    for i in range(0, entries/6):
        if(data.arrayMovementdata[2][i]==1): x="======="
        else: x="|"
        print i,  data.arrayMovementdata[0][i],  data.arrayMovementdata[1][i],  data.arrayMovementdata[3][i],  x


#        x=data.arrayMovementdata[0][entries/6]
#        if(x<10): m="0"+str(x)
#        else: m=str(x)
#    data.StopTime=str(data.arrayMovementdata[0][entries/6-1])+":"+m
#    print data.StopTime,  entries/6-1-1







