#!/usr/bin/env python
###########################################################################
# Name: 	         SleepAnalyser
# Description:	 Analyses your movement during your sleep and tries to set the alarm to a good time
# Copyright:     George Rui_collnelli, george@ruinelli.ch
# Last change:  (check version in data.py)
# Licence:         GPL
###########################################################################

import sys
import os
import random
#from PyQt4 import QtGui, QtCore
import time
from time import strftime
import math
import array
import string

from PyQt4.QtCore import * 
from PyQt4.QtGui import * 

import ConfigParser
import os, os.path

import data

from myFunctions import *

from Ui_StartWindow import *
from Ui_CollectingWindow import *
from Ui_LogWindow import *



  
###########################################################################
# Main function
###########################################################################
def main():
    global app,  StartWindow,  CollectingWindow,  LogWindow  #needed?
    global CollectingWindowGraph
   
    try:
        if(sys.argv[1]=="debug"): 
            print "Enable Debug mode"
            data.debug=1
    except:
        data.debug=0

    #if not on the N900, a acceleration sensor has to be simulated
    uname=os.uname()
    if(uname[1]=="Nokia-N900"): data.demo=0	#runs on real N900 hardware
    else: data.demo=1	#runs on other hardware/OS


    if(data.demo==1):
        print "Runs not on a N900 => Use randomizer for acceleration sensor data"
        data.configfolder=data.devconfigfolder
        data.logfolder=data.devlogfolder


    app = QtGui.QApplication(sys.argv)
    
    
    StartWindow = frmStartWindow()    
    CollectingWindow = frmCollectingWindow()
    LogWindow = frmLogWindow()
    
    
    StartWindow.show()
    

    #get configuration
    print "Configuration file:",  data.configfolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
    if os.path.exists(data.configfolder+data.ConfigFile):
        config.read(data.configfolder+data.ConfigFile)
        
        data.sampling = config.getint('main', 'sampling')
        data.sample_smoothing = config.getint('main', 'sample_smoothing')
        data.value_smoothing = config.getint('main', 'value_smoothing')
        data.trigger = config.getint('main', 'trigger')
        print "Configuration loaded ("+data.ConfigFile+")"
    else:
        print data.configfolder+data.ConfigFile + " not existing, using default parameters..."
        config.add_section('main')
        config.set('main', 'sampling', str(data.sampling))
        config.set('main', 'sample_smoothing', str(data.sample_smoothing))      
        config.set('main', 'value_smoothing', str(data.value_smoothing))      
        config.set('main', 'trigger', str(data.trigger))      

        if (not os.path.exists(data.configfolder)):
            print "Create configuration folder: ",  data.configfolder
            os.mkdir(data.configfolder)
        try:
            data.configfile = open(data.configfolder+data.ConfigFile, 'w')
            config.write(data.configfile)
            print "Configuration saved"
        except:
            print "Failed to write configuration file!"


    #faster sampling in demo mode
    if(data.debug==1):
        data.sampling=data.sampling/100
    
    #print usefull data
    print "SW version:", data.version
    print "Sampling intervall:", data.sampling, "ms"
    print "sample_smoothing:", data.sample_smoothing, "x"
    print "value_smoothing:", data.value_smoothing, "x"
    print "=> log intervall:", data.sampling*data.value_smoothing/1000, "s"
    print "Trigger level:", data.trigger


    
    StartWindow.UpdateScreenStart()
    StartWindow.show()



    sys.exit(app.exec_())







###########################################################################
# 
###########################################################################
def TimerLoop():
    global CollectingWindowGraph

    r=GetSensorData()
    if(r==1):
        WriteIntoLogFile()
        ProcessData()
        CollectingWindowGraph.update() #show CollectingWindowGraph    
    
    CollectingWindow.UpdateScreen()

  
  
  
  
###########################################################################
# 
###########################################################################
def ShowCollectingWindow():
    CollectingWindow.show()
    StartWindow.hide()
    StartMeasurement()
    
  
###########################################################################
# 
###########################################################################
def ShowLogWindow():
    global LogWindowGraph
    
    data.logfilename = QFileDialog.getOpenFileName(None,"Open SleepCycle Log File", data.logfolder, "Log Files (*.csv)");
    OpenLogFile()
    ProcessData()
    
    LogWindow.UpdateScreen()

    LogWindow.show()
    StartWindow.hide()
    
    LogWindowGraph = LogWindowCanvas()
    LogWindowGraph.show()





def Zoom():
    if(data.zoom==0): data.zoom=1
    else: data.zoom=0
    ProcessData()
    LogWindow.update()








###########################################################################
# 
###########################################################################
def StartMeasurement():
    global CollectingWindowGraph
    global app
    
    StartLogfile()
    
    #init value
    data.arrayMovementdata[0][0]=int(strftime("%H", time.localtime()))
    data.arrayMovementdata[1][0] =int(strftime("%M", time.localtime()))
    
    print data.arrayMovementdata[0][0],  data.arrayMovementdata[1][0]
    print "----------"
        
    CollectingWindowGraph = CollectingWindowCanvas()
    CollectingWindowGraph.show()

    print "Start timers..."
    app.timer_GetData = QtCore.QTimer()
    QtCore.QObject.connect(app.timer_GetData, QtCore.SIGNAL("timeout()"), TimerLoop)        
    app.timer_GetData.start(data.sampling)
    
    CollectingWindow.UpdateScreenStart()
    



###########################################################################
# 
###########################################################################
def StopMeasurement():
    global app

    print "Stop timers..."
    app.timer_GetData.stop()
    StopLogfile()



   
def RaiseTrigger():   
    data.trigger=data.trigger+1
    if(data.trigger>50): data.trigger=50
    
    ProcessData()
    LogWindowGraph.update() #show logWindowGraph    
    LogWindow.UpdateScreen()
    
   
   
   
def LowerTrigger():   
    data.trigger=data.trigger-1
    if(data.trigger<0): data.trigger=0
    
    ProcessData()
    LogWindowGraph.update() #show logWindowGraph    
    LogWindow.UpdateScreen()
   
   
   
   
def showGraph(self):
#        print "--"
        paint = QtGui.QPainter()
        paint.begin(self)

        paint.setFont(QtGui.QFont('Decorative', 12))
        
        #color = QtGui.QColor(0, 0, 0)
        #color.setNamedColor("gray") #or "#ffffff"
        paint.setPen(QtGui.QColor("gray"))
        paint.setBrush(QtGui.QColor("black"))

        #show CollectingWindowGraph border
        paint.drawRect(0,0,781,30)           

        h0=data.arrayMovementdata[0][0] #first hour
        m0=data.arrayMovementdata[1][0] #first minute
        # 1 minute = 1 px
#        print h0,  m0

        paint.setPen(QtGui.QColor("white"))
#        if(data.zoom==0): step=60
#        else: step=360
        for i in range(60-m0, 781,  60):
            paint.drawLine(i, 30, i, 35)  
            h=(h0+int(i/60)+1) % 24
            paint.drawText(i-15, 60, str(h)+":00")
            paint.drawLine(i, 30, i, 35) 
#            print i,  h




        #draw graph
#        print data.MovementData_ArrayUsage
        for i in range(0,  data.MovementData_ArrayUsage):
            if(data.arrayMovementdata[2][i]==1): #movement
                paint.setPen(QtGui.QColor("yellow"))
                paint.setBrush(QtGui.QColor("yellow"))
                paint.drawLine(i, 1, i, 29)  
                e=i-data.arrayMovementdata[3][i] #elapsed time since last movement in minutes
                if(e>1):
                    if(data.zoom==1):e=e/6
                    
                    if(e>30): color="#009100" #green
                    elif(e>15): color="#005000" #dark green
                    else: color="#6D0000" #dark red 

                    paint.setBrush(QtGui.QColor(color))
                    paint.setPen(QtGui.QColor(color))
                    x0=data.arrayMovementdata[3][i]+1
                    x1=i-1
                    paint.drawRect(x0, 1, x1-x0, 28) 
#                    print x0,  x1,  color
                
#                print i, "==="




def DeleteLogFile():
    LogWindow.DeleteLogFile()




###########################################################################
#  Class for Main Window
###########################################################################
class frmStartWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_StartWindow()
        self.ui.setupUi(self)

        QtCore.QObject.connect(self.ui.bCollecting, QtCore.SIGNAL("clicked()"), ShowCollectingWindow)
        QtCore.QObject.connect(self.ui.bLog, QtCore.SIGNAL("clicked()"), ShowLogWindow)


    def UpdateScreenStart(self):
        self.ui.lblVersion.setText(data.version)
#        self.ui.graphicsView.load(data.configfolder+"SleepAnalyser.png")



###########################################################################
#  Class for Collecting Window
###########################################################################
class frmCollectingWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_CollectingWindow()
        self.ui.setupUi(self)

    def UpdateScreen(self):
            self.ui.lblXacc.setText(str(data.arraySensorData[1][data.SensorData_ArrayIndex]))
            self.ui.lblYacc.setText(str(data.arraySensorData[2][data.SensorData_ArrayIndex]))
            self.ui.lblSamples_Taken.setText(str(data.values_total))

            t=time.mktime(time.localtime())
            time_difference=t-data.StartTimeSec
            t=strftime("%H:%M:%S", time.localtime(time_difference))
            self.ui.lblElapsedTime.setText(t)
            self.ui.lblTrigger.setText(str(data.trigger))
            

    def UpdateScreenStart(self):
        self.ui.lblLogfile.setText(str(data.logfilename))
        t= t=strftime("%d. %b %Y %H:%M:%S", data.StartTime)
        self.ui.lblStarttime.setText(t)


    def closeEvent(self, event):
#        print "Close CollectingWindow"
        StopMeasurement()
        CollectingWindow.close()
        StartWindow.show()

   
   


###########################################################################
# Class for Log Window
###########################################################################
class frmLogWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_LogWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bRaiseTrigger, QtCore.SIGNAL("clicked()"), RaiseTrigger)
        QtCore.QObject.connect(self.ui.bLowerTrigger, QtCore.SIGNAL("clicked()"), LowerTrigger)
        QtCore.QObject.connect(self.ui.cZoom, QtCore.SIGNAL("clicked()"), Zoom)
        QtCore.QObject.connect(self.ui.bDelete, QtCore.SIGNAL("clicked()"), DeleteLogFile)


    def UpdateScreen(self):
        self.ui.lblLogfile.setText(data.logfilename)
        x=data.arrayMovementdata[1][0]
#        if(x<10): m="0"+str(x)
#        else: m=str(x)
#        self.ui.lblStarttime.setText(str(data.arrayMovementdata[0][0])+":"+m)
        self.ui.lblStarttime.setText(data.arraySensorData[0][0])
#        m=data.arraySensorData[1][data.SensorData_ArrayIndex]
        self.ui.lblStoptime.setText(data.arraySensorData[0][data.SensorData_ArrayIndex-1])
        self.ui.lblTrigger.setText(str(data.trigger))


    def DeleteLogFile(self):
        reply = QtGui.QMessageBox.question(self, 'Delete Logfile', "Are you sure you want to delete this Logfile?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.Yes:
            print "Delete logfile: "+data.logfilename
            os.remove(data.logfilename)    
            StartWindow.show()
            LogWindow.hide()



    def closeEvent(self, event):
#        print "Close LogWindow"
        LogWindow.close()
        StartWindow.show()















###########################################################################
# Class for drawing the CollectingWindowGraph
###########################################################################
class CollectingWindowCanvas(QtGui.QWidget):

    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, CollectingWindow)    
        self.setGeometry(9, 300, 782, 100)
    
    def paintEvent(self, event):
        showGraph(self)



    
    
###########################################################################
# Class for drawing the LogWindowGraph
###########################################################################
class LogWindowCanvas(QtGui.QWidget):

    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, LogWindow)    
        self.setGeometry(9, 100, 782, 100)
    
    def paintEvent(self, event):
        showGraph(self)
    
    
    

###########################################################################
# Now we can start it.
main()

