import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data


###########################################################################
# Function to open or close the log file
###########################################################################
def StartLogfile():       
    #if not on the N900, use another place for the log file 
    if(data.demo==1): data.logfolder=data.devlogfolder #folder on devel PC
    
    print "Logfolder:",  data.logfolder
    try:
        os.mkdir(data.logfolder)
    except:
        print "Failed to create logfolder!"
        
    print "Get IMEI number..."
    if(data.demo==0):
        x = os.popen('run-standalone.sh dbus-send --system --print-reply --type=method_call --dest=com.nokia.phone.SIM /com/nokia/phone/SIM/security Phone.Sim.Security.get_imei').read()
        x2=string.split(x, "\"")
        imei=x2[1]
        ID=imei[10:]
    else: ID="00000"    
    
    #open file, write header
    data.StartTime=time.localtime()
    t=strftime("%Y-%b-%d_%H-%M-%S", data.StartTime)
    data.logfilename=data.logfolder+"SleepAnalyser_"+t+".csv"
    data.logfile = open(data.logfilename, 'w')
    print "Created logfile "+data.logfilename
    t="Date/Time, AccX, AccY"
    d=strftime("%d-%b-%Y", data.StartTime)
    data.logfile.write(t+"IMEI: *"+ID+", SW version: "+data.version+", Date: " + d + \
            ", Sampling intervall: " + str(data.sampling )+" ms, value_smoothing: " + \
            str(data.sample_smoothing )+"\n") #Print file header

    data.StartTimeSec=time.mktime(data.StartTime)







###########################################################################
#  Write data into file, so it can be used in other tools
###########################################################################
def WriteIntoLogFile():
    d=str(data.arrData[0][data.arrDataIndex]) + ", " +  \
        str(data.arrData[1][data.arrDataIndex]) + ", " +  \
        str(data.arrData[2][data.arrDataIndex])

    data.logfile.write(d+"\n")
    if(data.debug==1): print d



###########################################################################
#  Close log file
###########################################################################
def StopLogfile():
    data.logfile.close()




###########################################################################
#  Load old log file  to read and visualise it
###########################################################################
def OpenLogFile():    
    file = open(data.logfilename, 'r')

    data.arrDataIndex=0
    print "Open logfile",  data.logfilename
    try:
        header=file.readline()
        print "File data:",  header
        for line in file:
            d=string.split(line,  ", ")
            d[1]=int(d[1])
            d[2]=int(d[2])
            data.arrData[0][data.arrDataIndex]=d[0] #time
            data.arrData[1][data.arrDataIndex]=d[1] #X
            data.arrData[2][data.arrDataIndex]=d[2] #Y
            data.arrDataIndex=data.arrDataIndex+1            
            if(data.arrDataIndex==data.arrDataLen): 
                print "Stopped, array is full, file is to big"
                break
    finally:
        file.close()
    
    print "Loaded",  str(data.arrDataIndex),  "lines"
    
    
    
    
    
    
###########################################################################
# Load the configuration from the config file
###########################################################################
def LoadConfig():    
    #get configuration
    print "Configuration file:",  data.configfolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
#    if os.path.exists(data.configfolder+data.ConfigFile):
    try:
        config.read(data.configfolder+data.ConfigFile)
        
        data.sampling = config.getint('main', 'sampling')
        data.sample_smoothing = config.getint('main', 'sample_smoothing')
        data.value_smoothing = config.getint('main', 'value_smoothing')
        data.trigger = config.getint('main', 'trigger')
        data.derivation = config.getint('main', 'derivation')
        data.Ysize = config.getint('main', 'Ysize')
        data.Xscale = config.getint('main', 'Xscale')
        data.Yscale = config.getint('main', 'Yscale')
        print "Configuration loaded ("+data.ConfigFile+")"
#    else:
    except: #use default config
        print data.configfolder+data.ConfigFile + " not existing, using default parameters..."
        try:
            config.add_section('main')
        except:
            pass
        config.set('main', 'sampling', str(data.sampling))
        config.set('main', 'sample_smoothing', str(data.sample_smoothing))      
        config.set('main', 'value_smoothing', str(data.value_smoothing))      
        config.set('main', 'trigger', str(data.trigger))      
        config.set('main', 'derivation', str(data.derivation))      
        config.set('main', 'Ysize', str(data.Ysize))      
        config.set('main', 'Xscale', str(data.Xscale))     
        config.set('main', 'Yscale', str(data.Yscale))      

    #faster sampling in demo mode
    if(data.debug==1):
        data.sampling=data.sampling/100
    
    #print usefull data
    print "SW version:", data.version
    print "Sampling intervall:", data.sampling, "ms"
    print "sample_smoothing:", data.sample_smoothing, "x"
    print "value_smoothing:", data.value_smoothing, "x"
    print "=> log intervall:", data.sampling*data.value_smoothing/1000, "s"
    print "Trigger level:", data.trigger

    return config



###########################################################################
# Write the configuration into the config file
###########################################################################
def WriteConfig(config):
        f=data.configfolder+data.ConfigFile
        print "Save configuration ("+f+")"
        if (not os.path.exists(data.configfolder)):
            print "Create configuration folder: ",  data.configfolder
            os.mkdir(data.configfolder)
        try:
            data.configfile = open(f, 'w')
            config.write(data.configfile)
            print "Configuration saved"
        except:
            print "Failed to write configuration file!"
    
    
    
    
    
    

###########################################################################
# Read the sensor data x times and smoothen it
###########################################################################
def ReadAccSensor():
    
    coords=[0, 0]
    
    if(data.demo==0):
        
        for i in range(data.sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
        
        coords[0]=coords[0] / data.sample_smoothing
        coords[1]=coords[1] / data.sample_smoothing
        
    else:
        coords[0]=int(random.uniform(-50,50))
        coords[1]=int(random.uniform(-50,50))

    return coords








###########################################################################
# Get the smoothened sensor data, smoothen it again and fill the data into the main data array
###########################################################################
def GetSensorData():    
    d=ReadAccSensor()
    data.arrDataTemp[0]=data.arrDataTemp[0]+d[0]
    data.arrDataTemp[1]=data.arrDataTemp[1]+d[1]

    data.sample_index=data.sample_index+1
    
    if(data.sample_index==data.value_smoothing): #if is 10 runs over        
        data.sample_index=0
        data.arrDataIndex=data.values_total % data.arrDataLen
        data.values_total=data.values_total+1
        
        data.arrData[0][data.arrDataIndex]=strftime("%H:%M:%S", time.localtime())
        data.arrData[1][data.arrDataIndex]=data.arrDataTemp[0]/data.value_smoothing
        data.arrData[2][data.arrDataIndex]=data.arrDataTemp[1]/data.value_smoothing

        data.arrDataTemp[0]=0
        data.arrDataTemp[1]=0

        return 1 #added new values to arrData     
    else: return 0 #no new data added












###########################################################################
#  Process the data, generate movement indication
###########################################################################
def ProcessData():
    #DERIVATION (ABLEITUNG)
#        print i,  data.arrData[0][i] ,  data.arrData[1][i],  data.arrData[2][i]  
    for i in range(0, data.arrDataIndex-data.derivation):
        data.arrData[3][i]=data.arrData[1][i+data.derivation] - data.arrData[1][i] #X  in 5 sec - X now
        data.arrData[4][i]=data.arrData[2][i+data.derivation] - data.arrData[2][i] #Y  in 5 sec - Y now
#        print i,  i+data.derivation,  data.arrData[3][i],  data.arrData[4][i]


    lastmovement=0
    for i in range(0, data.arrDataIndex-data.derivation):
#        data.arrData[6][i]=lastmovement
        if((abs(data.arrData[3][i])+abs(data.arrData[4][i]))>data.trigger):
            data.arrData[5][i]=1
            lastmovement=i
        else:
            data.arrData[5][i]=0



#debug
#    for i in range(0, data.arrDataIndex-data.derivation):
#        if(data.arrData[5][i]==1): x="======="
#        else: x="|"
#        print i,  data.arrData[0][i],  data.arrData[4][i],  data.arrData[5][i],  data.arrData[6][i],  x
#











