/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QtCore/QString>
#include <QPen>
#include <QtTest/QtTest>

#include "coordinates/geocoordinate.h"
#include "coordinates/scenecoordinate.h"
#include "map/maprouteitem.h"
#include "routing/route.h"

class TestMapRouteItem : public QObject
{
    Q_OBJECT

public:
    TestMapRouteItem();

private Q_SLOTS:
    void testCase1();

private:
    Route route;

    GeoCoordinate coordinates[3];
};

TestMapRouteItem::TestMapRouteItem()
{
    // test points
    coordinates[0] = GeoCoordinate(12.3456, 54.3210);
    coordinates[1] = GeoCoordinate(65.5000, 25.0000);
    coordinates[2] = GeoCoordinate(-23.4567, 43.0987);

    // append points to route
    route.appendGeometryPoint(coordinates[0]);
    route.appendGeometryPoint(coordinates[1]);
    route.appendGeometryPoint(coordinates[2]);
}

void TestMapRouteItem::testCase1()
{
    MapRouteItem item;
    item.setRoute(&route);

    // check amount of lines
    QList<QGraphicsItem *> lines = item.childItems();
    QCOMPARE(lines.count(), 2);

    // test each line
    for (int i = 0; i < lines.count(); i++) {
        // check if the item really is a line item
        QGraphicsLineItem *lineItem = dynamic_cast<QGraphicsLineItem *>(lines.at(i));
        QVERIFY(lineItem);

        // check begin and end point scene coordinates of the line
        QLineF line = lineItem->line();
        QCOMPARE(line.p1(), SceneCoordinate(coordinates[i]).toPointF());
        QCOMPARE(line.p2(), SceneCoordinate(coordinates[i + 1]).toPointF());

        // check visual properties of the line
        QPen pen = lineItem->pen();
        QVERIFY(pen.isCosmetic());
        QCOMPARE(pen.width(), 5);
        QCOMPARE(pen.color(), QColor(Qt::red));
    }
}

QTEST_APPLESS_MAIN(TestMapRouteItem);

#include "testmaprouteitem.moc"
