/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef SEARCHDIALOG_H
#define SEARCHDIALOG_H

#include <QDialog>

class QDialogButtonBox;
class QLineEdit;

/**
* @brief Location search dialog
*
* @author Henri Lampela
*/
class SearchDialog : public QDialog
{
    Q_OBJECT

public:

    /**
    * @brief Constructor
    *
    * @param parent Instance of parent widget
    */
    SearchDialog(QWidget *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/

    /**
    * @brief Gets users input
    *
    * @returns users input
    */
    QString input();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/

private:

    QLineEdit *m_searchField;     ///< Pointer to search field
};

#endif // SEARCHDIALOG_H
