/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QDialogButtonBox>
#include <QHBoxLayout>
#include <QLineEdit>
#include <QPushButton>

#include "searchdialog.h"

SearchDialog::SearchDialog(QWidget *parent)
        : QDialog(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    setWindowTitle(tr("Location search"));

    m_searchField = new QLineEdit(this);

    QHBoxLayout *layout = new QHBoxLayout(this);
    QDialogButtonBox *buttonBox = new QDialogButtonBox(Qt::Vertical);
    QPushButton *searchButton = buttonBox->addButton(QDialogButtonBox::Ok);
    QPushButton *cancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);
    searchButton->setText(tr("Search"));

    layout->addWidget(m_searchField);
    layout->addWidget(buttonBox);

    connect(searchButton, SIGNAL(clicked()),
            this, SLOT(accept()));
    connect(cancelButton, SIGNAL(clicked()),
            this, SLOT(reject()));

    setLayout(layout);
}

QString SearchDialog::input()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_searchField->text();
}
