/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Jussi Laitinen - jussi.laitinen@ixonos.com
        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef ROUTINGPANEL_H
#define ROUTINGPANEL_H

#include <QtGui>

#include "panelbase.h"

class ExtendedListItemDelegate;
class GeoCoordinate;
class ImageButton;
class Route;
class RouteWaypointListView;

/**
 * @brief Routing panel
 *
 * @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
 * @author Sami Rämö - sami.ramo (at) ixonos.com
 */
class RoutingPanel : public PanelBase
{
    Q_OBJECT

public:
    /**
     * @brief Default constructor
     *
     * @param parent
     */
    RoutingPanel(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
    * @brief Re-implemented from QWidget::hideEvent()
    *
    * Calls clearListsSelections()
    *
    * @param event
    */
    void hideEvent(QHideEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
private slots:
    /**
    * @brief Clears lists' selections.
    */
    void clearListsSelections();

    /**
    * @brief Handler for clear route button clicks
    */
    void clearRouteButtonClicked();

    /**
    * @brief Sets route to the panel.
    *
    * Appends route waypoint list with route segments.
    *
    * @param route Route item containing parsed route details
    */
    void setRoute(Route &route);

    /**
     * @brief show / hide empty panel label
     *
     * @param show true if empty panel should be shown
     */
    void showEmptyPanel(bool show);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Emitted when route is cleared
    */
    void clearRoute();

    /**
    * @brief Request routing to current cursor position
    */
    void routeToCursor();

    /**
    * @brief Signal for route waypoint item clicked.
    *
    * @param coordinate waypoint item's coordinate
    */
    void routeWaypointItemClicked(const GeoCoordinate &coordinate);

    /**
     * @brief Signal for requesting a panel to be opened
     *
     * @param widget Pointer to the widget that emitted the signal
     */
    void showPanelRequested(QWidget *widget);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QLabel *m_noRouteLabel;                             ///< Text label for empty panel
    QLabel *m_resultsLabel;                             ///< Location list label

    ImageButton *m_clearRouteButton;                    ///< Search location button
    RouteWaypointListView *m_routeWaypointListView;     ///< Route instructions list view
};

#endif // ROUTINGPANEL_H
