#include <QDebug>
#include <QTime>

#include "avatarimage.h"
#include "listcommon.h"
#include "routing/routesegment.h"

#include "routewaypointlistitem.h"

RouteWaypointListItem::RouteWaypointListItem()
    : ExtendedListItem()
{
    qDebug() << __PRETTY_FUNCTION__;

    setSubitemTextWidth(SUBITEM_TEXT_MAX_WIDTH);
}

GeoCoordinate RouteWaypointListItem::coordinates() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_coordinates;
}

void RouteWaypointListItem::setRouteWaypointData(const RouteSegment &routeSegment,
                                                 const GeoCoordinate &coordinate)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_coordinates = coordinate;

    setTurnTypeImage(routeSegment.turnType());

    setTitle(shortenText(routeSegment.street(), NAME_TEXT_MAX_WIDTH + MARGIN,
                        ListItem::TEXT_SIZE_NORMAL));

    clearSubItems();

    QTime zeroTime;
    QTime segmentTravelTime = zeroTime.addSecs(routeSegment.time());
    addSubItem(segmentTravelTime.toString("hh:mm:ss"), QPixmap(":/res/images/clock.png"));

    addSubItem(routeSegment.lengthCaption(), QPixmap(":/res/images/ruler.png"));
}

void RouteWaypointListItem::setTurnTypeImage(const QString &turnType)
{
    if (turnType == "C") {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_continue.png"),
                                     AvatarImage::Small));
    } else if (turnType == "TL") {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_left.png"),
                                     AvatarImage::Small));
    } else if (turnType == "TSLL") {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_slight_left.png"),
                                     AvatarImage::Small));
    } else if (turnType == "TSHL") {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_sharp_left.png"),
                                     AvatarImage::Small));
    } else if (turnType == "TR") {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_right.png"),
                                     AvatarImage::Small));
    } else if (turnType == "TSLR") {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_slight_right.png"),
                                     AvatarImage::Small));
    } else if (turnType == "TSHR") {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_sharp_right.png"),
                                     AvatarImage::Small));
    } else if (turnType == "TU") {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_u_turn.png"),
                                     AvatarImage::Small));
    } else if (turnType.startsWith("EXIT")) {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_roundabout.png"),
                                     AvatarImage::Small));
    } else {
        setImage(AvatarImage::create(QPixmap(":/res/images/arrow_turn_start.png"),
                                     AvatarImage::Small));
    }

}

RouteWaypointListItem::~RouteWaypointListItem()
{
    qDebug() << __PRETTY_FUNCTION__;
}
