/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef LISTITEM_H
#define LISTITEM_H

#include <QListWidgetItem>

/**
* @brief Base class for list items.
*
* Stores item's name and image and includes method to shorten texts.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class ListItem : public QListWidgetItem
{

public:
    /**
    * @brief Constructor.
    */
    ListItem();

    /**
    * @brief Defines text size.
    */
    enum TextSize{TEXT_SIZE_NORMAL, TEXT_SIZE_SMALL};

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Sets item's image.
    *
    * @param image QPixmap
    */
    void setImage(const QPixmap &image);

    /**
    * @brief Sets item's title.
    *
    * @param name item's title
    */
    void setTitle(const QString &name);

    /**
    * @brief Sets item selected.
    *
    * @param selected true if selected, false otherwise
    */
    virtual void setSelected(bool selected) = 0;

    /**
    * @brief Sets item size.
    *
    * @param size item size
    */
    void setSize(const QSize &size);

    /**
    * @brief Shortens text defined by text width.
    *
    * @param text text to be shortened
    * @param textWidth the width the text can use
    * @param textSize which text size to use
    * @return shortened text
    */
    QString shortenText(const QString &text, int textWidth, TextSize textSize);

    /**
    * @brief Returns item's title.
    *
    * @return item's title
    */
    QString title() const;

    /**
    * @brief Toggles selection.
    *
    * @return true if selection was toggled, false otherwise
    */
    virtual bool toggleSelection() = 0;

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QPixmap m_image;    ///< Item's image
    QString m_name;     ///< Item's name
};

#endif // LISTITEM_H
