/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/


#ifndef EXTENDEDLISTITEMSTORE_H
#define EXTENDEDLISTITEMSTORE_H

#include <QPixmap>
#include <QRect>
#include <QString>

/**
* @brief Stores ExtendedListItem data.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class ExtendedListItemStore
{
public:
    /**
    * @brief Constructor.
    *
    * Sets text.
    * @param text item text
    */
    ExtendedListItemStore(const QString &text);

/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Returns icon.
    *
    * @return QPixmap
    */
    QPixmap icon() const;

    /**
    * @brief Sets icon.
    *
    * @param icon item icon
    */
    void setIcon(const QPixmap &icon);

    /**
    * @brief Sets shortended text.
    *
    * @param shortenedText shortened text
    */
    void setShortenedText(const QString &shortenedText);

    /**
    * @brief Returns shortened text.
    *
    * @return QString
    */
    QString shortenedText() const;

    /**
    * @brief Sets text rect.
    *
    * @param textRect text rect
    */
    void setTextRect(const QRect &textRect);

    /**
    * @brief Returns text
    *
    * @return QString
    */
    QString text() const;

    /**
    * @brief Returns text rect.
    *
    * @return QRect
    */
    QRect textRect() const;

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    QPixmap m_icon;             ///< Icon pixmap
    QRect m_textRect;           ///< Text rect
    QString m_text;             ///< Text string
    QString m_shortenedText;    ///< Shortened text string
};

#endif // EXTENDEDLISTITEMSTORE_H
