/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef NETWORKHANDLER_H
#define NETWORKHANDLER_H

#include <QObject>

class NetworkHandlerPrivate;

/**
* @brief NetworkHandler class.
*
* This class handles network connection. Class notifies about
* network connection states.
*/
class NetworkHandler : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Friend class for NetworkHandlerPrivate.
    */
    friend class NetworkHandlerPrivate;

    /**
    * @brief Returns instance of NetworkHandler.
    *
    * Creates instance if not created.
    */
    static NetworkHandler *instance();

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Requests network connection.
    *
    * Request is done via ICD D-Bus.
    */
    void connect();

    /**
    * @brief Requests to disconnect a connection.
    *
    * Request is done via ICD D-Bus.
    */
    void disconnect();

    /**
    * @brief Checks if connected to network.
    *
    * @return true if connected, false otherwise
    */
    bool isConnected();

    /**
    * @brief Requests network state.
    */
    void state();

protected:
    /**
    * @brief Constructor.
    *
    * Instance of this class can only be created by using instance method.
    */
    NetworkHandler();

    /**
    * @brief Destructor.
    *
    * Destructor is not accessible.
    */
    ~NetworkHandler();
/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signals when connected to network.
    */
    void connected();

    /**
    * @brief Signals when disconnected from network.
    */
    void disconnected();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    static NetworkHandler *m_instance;              ///< Instance of NetworkHandler
    NetworkHandlerPrivate *m_networkHandlerPrivate; ///< Instance of NetworkHandlerPrivate
};

#endif // NETWORKHANDLER_H
