/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef GEOPOSITIONINFO_H
#define GEOPOSITIONINFO_H

#include <QObject>
#include <QDateTime>

#include "coordinates/geocoordinate.h"

/**
* @brief GeoPositionInfo class stores geo position info.
*/
class GeoPositionInfo
{
public:
    /**
    * @brief Constructor.
    */
    GeoPositionInfo();

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Returns accuracy.
    *
    * Returns -1 if accuracy is not accurate.
    *
    * @return qreal
    */
    qreal accuracy() const;

    /**
    * @brief Returns geo coordinates.
    *
    * @return GeoCoordinate
    */
    GeoCoordinate coordinate() const;

    /**
    * @brief Checks if the accuracy is accurate.
    *
    * @return true if accurate, false otherwise
    */
    bool isAccurate() const;

    /**
    * @brief Checks the validity of the GeoPositionInfo.
    *
    * Checks coordinate validity.
    *
    * @return true if valid, false otherwise
    */
    bool isValid();

    /**
    * @brief Sets accuracy.
    *
    * @param accurate true if accuracy is accurate (satellite positioning)
    * @param accuracy accuracy value
    */
    void setAccuracy(bool accurate, qreal accuracy);

    /**
    * @brief Sets geo coordinates.
    *
    * @param coordinate GeoCoordinate
    */
    void setCoordinate(const GeoCoordinate &coordinate);


    /**
    * @brief Sets timestamp.
    *
    * @param time timestamp in seconds
    */
    void setTimestamp(qreal time);

    /**
    * @brief Returns timestamp.
    *
    * @return QDateTime
    */
    QDateTime timestamp() const;

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    QDateTime m_timestamp;      ///< Timestamp
    GeoCoordinate m_coordinate; ///< GeoCoordinate
    qreal m_horizontalAccuracy; ///< Horizontal accuracy
    bool m_isAccurate;          ///< Is accurate
};

#endif // GEOPOSITIONINFO_H
