/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QX11Info>
#include <QDebug>

#include "application.h"

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>

#ifdef Q_WS_HILDON
    #define ACTIVE_APP_ATOM "_MB_CURRENT_APP_WINDOW"
#else
    #define ACTIVE_APP_ATOM "_NET_ACTIVE_WINDOW"
#endif

Application::Application(int &argc, char **argv)
    : QApplication(argc, argv),
    m_topmost(false)
{
    qDebug() << __PRETTY_FUNCTION__;
}

void Application::registerWindow(WId window)
{
    qDebug() << __PRETTY_FUNCTION__;

   m_windows.append(window);
}

void Application::unregisterWindow(WId window)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_windows.removeOne(window);
}

WId Application::activeDesktopWindow(Display *display, WId rootWindow)
{
    qDebug() << __PRETTY_FUNCTION__;

    Atom realType;
    int format, status;
    unsigned long n, extra;
    unsigned char *data = 0;
    WId activeWindow;
    Atom atom = XInternAtom(display, ACTIVE_APP_ATOM, false);

    status = XGetWindowProperty(display, rootWindow, atom, 0L, 16L,
                        0, XA_WINDOW, &realType, &format,
                        &n, &extra, &data);
    if (status == Success && realType == XA_WINDOW &&
        format == 32 && n == 1 && data != NULL)
        activeWindow = ((WId*)data)[0];
    else
        activeWindow = None;

    if (data != 0)
        XFree(data);

    return activeWindow;
}

bool Application::x11EventFilter(XEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    static Qt::HANDLE rootWindow = QX11Info::appRootWindow();
    static Atom activeAppAtom = XInternAtom(QX11Info::display(), ACTIVE_APP_ATOM, false);

    switch (event->type) {
    case PropertyNotify: {
            XPropertyEvent *pevent = (XPropertyEvent*)event;
            if (pevent->window == rootWindow) {
                if (pevent->atom == activeAppAtom) {
                    WId activeWindow = activeDesktopWindow(pevent->display, rootWindow);

                    if(m_topmost != m_windows.contains(activeWindow)) {
                        m_topmost = !m_topmost;
                        emit topmostWindowChanged(m_topmost);
                    }
                }
            }
        }
        break;
    case KeyPress:
    case KeyRelease:
    case ButtonPress:
    case ButtonRelease:
    case MotionNotify:
    case EnterNotify: // required when returning from statusbar menu
    case FocusIn: // required when returning from update location dialog
        emit showFullScreenButton();
        break;
    }

    // don't block any events here, so false is returned
    return false;
}
