/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QtTest>

#include "ui/extendedlistitemstore.h"
#include "ui/listcommon.h"
#include "user/user.h"

#include "ui/friendlistitem.h"

class TestFriendListItem: public QObject
{
    Q_OBJECT

private slots:
    void cleanupTestCase();
    void initTestCase();
    void setUserData();
    void toggleSelection();

private:
    FriendListItem *friendListItem;
    User *user1;
    User *user2;
};

void TestFriendListItem::cleanupTestCase()
{
    delete friendListItem;
    delete user1;
    delete user2;
}

void TestFriendListItem::initTestCase()
{
    friendListItem = new FriendListItem();

    user1 = new User(QString("Address address address address address"),
                           GeoCoordinate(12.22, 23.33), QString("Name na msfdsa dsfadsaf sdaf"),
                           QString("Note note note note note note note note note note note note " \
                                   "note note note note note"),
                           QUrl("http://image.url"), QString("Timestamp timestamp timestamp tim"),
                           true, QString("id1"), QString("km"), 44.12);
    user1->setProfileImage(QPixmap(":/res/images/profile_pic_border.png"));

    user2 = new User(QString("Address address"),
                           GeoCoordinate(12.1, 44.33), QString("Name na msfdsa dsfadsaf sdaf"),
                           QString("Note note note note note note note note note note note note" \
                                   "note note note note note"),
                           QUrl("http://image.url"), QString("Timestamp timestamp timestamp tim"),
                           true, QString("id2"), QString("km"), 144.12);
    user2->setProfileImage(QPixmap(":/res/images/profile_pic_border.png"));

    QVERIFY(friendListItem != 0);
    QVERIFY(user1 != 0);
    QVERIFY(user2 != 0);
}

void TestFriendListItem::setUserData()
{
    friendListItem->setUserData(user1);
    QCOMPARE(friendListItem->coordinates().latitude(), GeoCoordinate(12.22, 23.33).latitude());
    QCOMPARE(friendListItem->coordinates().longitude(), GeoCoordinate(12.22, 23.33).longitude());

    QPixmap profileImage = QPixmap(qvariant_cast<QPixmap>(friendListItem->data(
            AVATAR_IMAGE_INDEX)));
    QCOMPARE(profileImage, QPixmap(":/res/images/profile_pic_border.png"));

    friendListItem->setUserData(user2);
    QCOMPARE(friendListItem->coordinates().latitude(), GeoCoordinate(12.1, 44.33).latitude());
    QCOMPARE(friendListItem->coordinates().longitude(), GeoCoordinate(12.1, 44.33).longitude());
}

void TestFriendListItem::toggleSelection()
{
    QCOMPARE(friendListItem->data(ITEM_SIZE_HINT_INDEX).toSize(), QSize(368, 139));

    QList<ExtendedListItemStore *> *subItems = (QList<ExtendedListItemStore *> *)
                                               (friendListItem->data(SUBITEM_STORE_INDEX)
                                                .value<void *>());

    QVERIFY(friendListItem->data(ITEM_HAS_IMAGE_INDEX).toBool());

    QVERIFY(subItems);
    QCOMPARE(subItems->count(), 3);

    friendListItem->toggleSelection();
    QCOMPARE(friendListItem->data(ITEM_EXPANDED_INDEX).toBool(), true);

    friendListItem->toggleSelection();
    QCOMPARE(friendListItem->data(ITEM_SIZE_HINT_INDEX).toSize(), QSize(368, 139));
    QCOMPARE(friendListItem->data(ITEM_EXPANDED_INDEX).toBool(), false);
}

QTEST_MAIN(TestFriendListItem)
#include "testfriendlistitem.moc"
