 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */

#ifndef ZOOMBUTTON_H
#define ZOOMBUTTON_H

#include "imagebutton.h"

/**
 * @brief A class for Zoom Buttons
 *
 * @author Kaj Wallin - kaj.wallin (at) ixonos.com
 */
class ZoomButton : public ImageButton
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param iconPictureFileName Icon image file name
     * @param parent Parent
     */
    ZoomButton(const QString &iconPictureFileName = QString(), QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Event handler for mouse move events
     *
     * @param event Mouse event
     */
    void mouseMoveEvent(QMouseEvent *event);

    /**
     * @brief Event handler for mouse press events
     *
     * @param event Mouse event
     */
    void mousePressEvent(QMouseEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
     * @brief Relative position of the event inside the widget
     */
    const QPoint& eventPosition();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QTimer *m_dragStartTimer;   ///< Mouse press timer, initiates drag mode
    QPoint m_eventPosition;     ///< Position of mousePressEvent
};

#endif // ZOOMBUTTON_H
