#ifndef OSSOABOOKDIALOG_H
#define OSSOABOOKDIALOG_H

#include <QObject>
#include <QStringList>

#undef signals // Collides with GTK symbols
#include <libosso-abook/osso-abook.h>

/**
* @brief Shows contact dialog.
*/
class OssoABookDialog : public QObject
{
    Q_OBJECT
public:
    /**
    * @brief Constructor
    *
    * @param parent QObject
    */
    OssoABookDialog(QObject *parent = 0);

/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
    /**
    * @brief Shows contact dialog.
    *
    * @param id contact ID
    */
    static void showContactDialog(const QString &id);

private:
    /**
    * @brief Returns address book contact.
    *
    * @param id contact ID
    * @return OssoABookContact
    */
    static OssoABookContact *lookup(const QString& id);
};

#endif // OSSOABOOKDIALOG_H
