/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QPainter>

#include "../common.h"
#include "listcommon.h"
#include "textmodifier.h"

#include "listitem.h"

ListItem::ListItem()
{
    qDebug() << __PRETTY_FUNCTION__;

    setSize(QSize(ITEM_WIDTH, ITEM_MIN_HEIGHT));
}

QString ListItem::title() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return data(TITLE_DISPLAY_INDEX).toString();
}

void ListItem::setImage(const QPixmap &image)
{
    qDebug() << __PRETTY_FUNCTION__;

    setData(ITEM_HAS_IMAGE_INDEX, true);
    setData(AVATAR_IMAGE_INDEX, image);

}

void ListItem::setTitle(const QString &title)
{
    qDebug() << __PRETTY_FUNCTION__;

    setData(TITLE_DISPLAY_INDEX, title);
}

void ListItem::setSize(const QSize &size)
{
    qDebug() << __PRETTY_FUNCTION__;

    setData(ITEM_SIZE_HINT_INDEX, size);
}

QString ListItem::shortenText(const QString &text, int textWidth, TextSize textSize)
{
    qDebug() << __PRETTY_FUNCTION__;

    QPixmap p = QPixmap(ICON_WIDTH, ICON_HEIGHT);
    QPainter painter(&p);

    if (textSize == ListItem::TEXT_SIZE_NORMAL)
        painter.setFont(NOKIA_FONT_NORMAL);
    else
        painter.setFont(NOKIA_FONT_SMALL);

    QFontMetrics textMetrics = painter.fontMetrics();

    return TextModifier::shortenText(textMetrics, text, textWidth);
}
