/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Katri Kaikkonen - katri.kaikkonen@ixonos.com
        Kaj Wallin - kaj.wallin@ixonos.com
        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef INDICATORBUTTON_H
#define INDICATORBUTTON_H

#include <QMouseEvent>
#include <QTimer>
#include <QToolButton>

/**
 * @brief Indicator button class
 *
 * @author Katri Kaikkonen - katri.kaikkonen (at) ixonos.com
 * @author Kaj Wallin - kaj.wallin (at) ixonos.com
 * @author Sami Rämö - sami.ramo (at) ixonos.com
 */
class IndicatorButton : public  QToolButton
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent widget
     */
    IndicatorButton(QWidget *parent = 0);

    /**
     * @brief Desctructor
     */
    ~IndicatorButton();

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Event handler for mouse press events
     *
     * @param event Mouse event
     */
    void mousePressEvent(QMouseEvent *event);

    /**
     * @brief Event handler for mouse release events
     *
     * @param event Mouse event
     */
    void mouseReleaseEvent(QMouseEvent *event);

    /**
     * @brief Event handler for paint events
     *
     * Paints the button and its icon
     * @param event Paint event
     */
    void paintEvent(QPaintEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
     * @brief Relative position of the event inside the widget
     */
    const QPoint& eventPosition();

    /**
     * @brief Sets direction information for the distance indicator button
     *
     * Paints the button and its icon
     *
     * @param direction Direction to the GPS position (in degrees)
     * @param draw True if direction triangle should be drawn
     */
    void setDirection(qreal direction, bool draw);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
     * @brief Automatic centering setting changed by user
     *
     * @param enabled True if automatic centering is enabled, otherwise false
     */
    void autoCenteringTriggered(bool enabled);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    bool m_drawTriangle;                    ///< Should the direction triange be drawn

    qreal m_direction;                      ///< Direction to the GPS position (in degrees)

    QColor *m_normalColor;                  ///< Normal background color

    QLinearGradient *m_selectedGradient;    ///< Selected background

    QPixmap m_indicatorLeds[2];             ///< Placeholder for images

    QPoint m_dragPosition;                  ///< Location from where the widget is grabbed
    QPoint m_eventPosition;                 ///< Position of mousePressEvent
};

#endif // INDICATORBUTTON_H
