/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QPainter>
#include <QDebug>
#include <QRect>

#include "../common.h"
#include "listcommon.h"
#include "extendedlistitemstore.h"

#include "extendedlistitemdelegate.h"

ExtendedListItemDelegate::ExtendedListItemDelegate(QWidget *parent)
    : ListItemDelegate(parent)
{
    qDebug() << __PRETTY_FUNCTION__;
}

void ExtendedListItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,
                                     const QModelIndex &index) const
{
    qDebug() << __PRETTY_FUNCTION__;

    ListItemDelegate::paint(painter, option, index);

    painter->setPen(COLOR_GRAY);
    painter->setFont(NOKIA_FONT_SMALL);

    QRect itemRect = option.rect;
    QList<ExtendedListItemStore *> *subItems = (QList<ExtendedListItemStore *> *)
                                               (index.data(SUBITEM_STORE_INDEX).value<void *>());
    bool expanded = index.data(ITEM_EXPANDED_INDEX).toBool();
    bool itemHasImage = index.data(ITEM_HAS_IMAGE_INDEX).toBool();

    if (subItems) {

        int previousSubItemTextRectBottom = itemRect.top() + IMAGE_HEIGHT - 2 * MARGIN;

        for (int i = 0; i < subItems->size(); ++i) {

            ExtendedListItemStore *itemStore = subItems->at(i);
            QRect subItemTextRect = itemStore->textRect();
            QString text;

            if (expanded) {
                text = itemStore->text();
            }
            else {
                subItemTextRect.setHeight(SUBITEM_TEXT_ROW_HEIGHT);
                text = itemStore->shortenedText();
            }

            QRect iconRect = QRect(itemRect.left() + MARGIN * 3,
                                   previousSubItemTextRectBottom + ICON_MARGIN,
                                   ICON_WIDTH, ICON_HEIGHT);

            if (itemHasImage)
                iconRect.translate(IMAGE_WIDTH, 0);

            subItemTextRect.translate(iconRect.right() + MARGIN, iconRect.top());

            if (!itemStore->icon().isNull())
                painter->drawPixmap(iconRect, itemStore->icon());

            painter->drawText(subItemTextRect, Qt::TextWordWrap, text);
            previousSubItemTextRectBottom = subItemTextRect.bottom() + ICON_MARGIN;
        }
    }
}
