/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>

#include "networkreply.h"

NetworkReply::NetworkReply(const QNetworkRequest &request, QObject *parent)
    : QNetworkReply(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    setRequest(request);
}

void NetworkReply::abort()
{
    qDebug() << __PRETTY_FUNCTION__;
}

qint64 NetworkReply::readData(char *data, qint64 maxlen)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (m_offset < m_content.size()) {
        qint64 number = qMin(maxlen, m_content.size() - m_offset);
        memcpy(data, m_content.constData() + m_offset, number);
        m_offset += number;
        return number;
    } else
        return -1;
}

void NetworkReply::setErrorCode(QNetworkReply::NetworkError errorCode)
{
    qDebug() << __PRETTY_FUNCTION__;

    setError(errorCode, "");
}
