/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>

#include "networkhandler.h"

#if defined(Q_WS_MAEMO_5) & defined(ARMEL)
#include "networkhandlerprivate.h"
#else
#include "networkhandlerprivatestub.h"
#endif

NetworkHandler *NetworkHandler::m_instance = 0;

NetworkHandler::NetworkHandler()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_networkHandlerPrivate = new NetworkHandlerPrivate(this);
}

NetworkHandler::~NetworkHandler()
{
    qDebug() << __PRETTY_FUNCTION__;
}

void NetworkHandler::connect()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_networkHandlerPrivate->connect();
}

void NetworkHandler::disconnect()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_networkHandlerPrivate->disconnect();
}

NetworkHandler *NetworkHandler::instance()
{
    qDebug() << __PRETTY_FUNCTION__;

    if (!m_instance)
        m_instance = new NetworkHandler();

    return m_instance;
}

bool NetworkHandler::isConnected()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_networkHandlerPrivate->isConnected();
}

void NetworkHandler::state()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_networkHandlerPrivate->state();
}
