/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Henri Lampela - henri.lampela@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include "networkcookiejar.h"
#include <QDebug>

NetworkCookieJar::NetworkCookieJar(QObject *parent) :
    QNetworkCookieJar(parent)
{
    m_cookieList.clear();
}

void NetworkCookieJar::setAllCookies(const QList<QNetworkCookie> &cookieList)
{
    m_cookieList = cookieList;
}

QList<QNetworkCookie> NetworkCookieJar::allCookies() const
{
    return m_cookieList;
}

bool NetworkCookieJar::setCookiesFromUrl(const QList<QNetworkCookie> &cookieList, const QUrl &url)
{
    Q_UNUSED(url);

    QList<QNetworkCookie> cookies = allCookies();
    foreach(QNetworkCookie cookie, cookieList) {
        cookies += cookie;
    }
    setAllCookies(cookies);

    return true;
}

QList<QNetworkCookie> NetworkCookieJar::cookiesForUrl ( const QUrl & url ) const
{
    Q_UNUSED(url);
    return m_cookieList;
}
