/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QVariantAnimation>

#include "coordinates/scenecoordinate.h"

#include "mapscroller.h"

/////////////////////////////////////////////////////////////////////////////
// scene coordinate interpolator function is not part of this class namespace
/////////////////////////////////////////////////////////////////////////////
QVariant sceneCoordinateInterpolator(const SceneCoordinate &start,
                                     const SceneCoordinate &end,
                                     qreal progress);

MapScroller& MapScroller::getInstance()
{
    qDebug() << __PRETTY_FUNCTION__;

    qRegisterAnimationInterpolator<SceneCoordinate>(sceneCoordinateInterpolator);

    static MapScroller instance;
    return instance;
}

void MapScroller::updateCurrentValue(const QVariant &value)
{
    qDebug() << __PRETTY_FUNCTION__;

    if ((state() == QAbstractAnimation::Running) && (value.canConvert<SceneCoordinate>()))
        emit coordinateUpdated(value.value<SceneCoordinate>());
}

/////////////////////////////////////////////////////////////////////////////
// scene coordinate interpolator function is not part of this class namespace
/////////////////////////////////////////////////////////////////////////////
QVariant sceneCoordinateInterpolator(const SceneCoordinate &start,
                                                  const SceneCoordinate &end,
                                                  qreal progress)
{
    qDebug() << __PRETTY_FUNCTION__;

    return SceneCoordinate(start + progress * (end - start));
}
