/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Sami Rämö - sami.ramo@ixonos.com
       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef MAPCOMMON_H
#define MAPCOMMON_H

#include <QtCore>

#include "osm.h"

const int MAP_TILE_MIN_INDEX = 0; ///< First index number of map tiles

const int MAP_VIEW_MIN_ZOOM_LEVEL = 2; ///< Minimum zoom level for MapView

/**
* @var MAP_SCENE_MIN_NORMAL_LEVEL
* @brief Used for shifting zValues of MapTiles
*/
const int MAP_SCENE_MIN_NORMAL_LEVEL = OSM_MAX_ZOOM_LEVEL + 1;

const double MAP_SCENE_VERTICAL_OVERSIZE_FACTOR = 0.5; ///< MapScene vertical oversize ( * map size)

/**
* @var MAP_SCENE_MIN_PIXEL_X
* @brief First scene horizontal pixel
*/
const int MAP_SCENE_MIN_PIXEL_X = -OSM_MAP_PIXELS_X * MAP_SCENE_VERTICAL_OVERSIZE_FACTOR;

/**
* @var MAP_SCENE_MAX_PIXEL_X
* @brief Last scene horizontal pixel
*/
const int MAP_SCENE_MAX_PIXEL_X = OSM_MAP_PIXELS_X * (1 + MAP_SCENE_VERTICAL_OVERSIZE_FACTOR) - 1;

////////////////////////////////////////////////////////////////////////////////
// DEFAULT VALUES
////////////////////////////////////////////////////////////////////////////////
/**
* @var MAP_DEFAULT_ZOOM_LEVEL
* @brief Maps Default zoom level, used when latest zoom level is not available.
*/
const int MAP_DEFAULT_ZOOM_LEVEL = MAP_VIEW_MIN_ZOOM_LEVEL;
const qreal MAP_DEFAULT_LONGITUDE = 0.0000;  ///< Default longitude value
const qreal MAP_DEFAULT_LATITUDE = 0.0000; ///< Default latitude value

const int GROUP_ITEM_FRIENDS_COUNT_X = 13;  ///< Group item friends count x value
const int GROUP_ITEM_FRIENDS_COUNT_Y = 13;  ///< Group item friends count y value
const int GROUP_ITEM_FRIENDS_COUNT_WIDTH = 17;  ///< Group item friends count width value
const int GROUP_ITEM_FRIENDS_COUNT_HEIGHT = 17; ///< Group item friends count height value

const int PRESS_MANHATTAN_LENGTH = 30;   ///< Friend/group item press manhattan length

const double MIN_LONGITUDE = -180.0;  ///< Minimum longitude value
const double MAX_LONGITUDE = 180.0;  ///< Maximum longitude value

const int MAP_GRID_PADDING = 0;  ///< Grid padding used in tile grid calculation

const QString OSM_LICENSE = QString::fromUtf8("© OpenStreetMap contributors, CC-BY-SA");

const int AUTO_CENTERING_DISABLE_DISTANCE = 50; ///< Distance in pixels

//String constants for storing map settings:
const QString MAP_LAST_ZOOMLEVEL = "LAST_MAP_ZOOM_LEVEL";   ///< Maps last zoom level before logout
const QString MAP_LAST_POSITION = "LAST_MAP_LOCATION";      ///< Maps last postion before logout
/**
* @var ERROR_VALUE_NOT_FOUND_ON_SETTINGS
* @brief Error string that program will get if value is not found on settings
*/
const QString ERROR_VALUE_NOT_FOUND_ON_SETTINGS = "Value_not_found";

/**
* @var UNDEFINED
* @brief Value to be used when zoom level, tile numbers or position are not defined
*/
const int UNDEFINED = INT_MIN;

/**
* @enum SceneItemZValues
*
* @brief Z level values for different MapScene items
*/
enum SceneItemZValues {
    RouteItemZValue = MAP_SCENE_MIN_NORMAL_LEVEL + OSM_MAX_ZOOM_LEVEL + 1,
    FriendLocationItemZValue,
    GPSLocationItemZValue
};

#endif // MAPCOMMON_H
