/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Ville Tiensuu - ville.tiensuu@ixonos.com
       Sami Rämö - sami.ramo@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QGraphicsSceneMouseEvent>
#include <QIcon>
#include "friendlocationitem.h"
#include "mapcommon.h"

FriendLocationItem::FriendLocationItem(const QString &userId,
                                       QObject *parent)
    : BaseLocationItem(parent),
      m_partOfGroup(false),
      m_userId(userId),
      m_mousePressPosition(QPoint(0, 0)),
      m_clickEvent(false)
{
    qDebug() << __PRETTY_FUNCTION__;

    setPos(UNDEFINED, UNDEFINED);
    setZValue(FriendLocationItemZValue);
}

bool FriendLocationItem::isPartOfGroup() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_partOfGroup;
}

void FriendLocationItem::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_mousePressPosition = event->pos();
    m_clickEvent = true;
    update();
}

void FriendLocationItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (m_clickEvent) {
        if ((event->pos() - m_mousePressPosition).manhattanLength() > PRESS_MANHATTAN_LENGTH) {
            m_clickEvent = false;
            update();
        }
    }
}

void FriendLocationItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(event);

    if (m_clickEvent) {
        m_clickEvent = false;
        QList<QString> userIDs;
        userIDs.append(m_userId);

        emit locationItemClicked(userIDs);
    }

    update();
}

void FriendLocationItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                               QWidget *widget)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (m_clickEvent) {
        QIcon icon;
        icon.addPixmap(pixmap());
        painter->drawPixmap(offset(), icon.pixmap(pixmap().size(), QIcon::Selected,
                                                                 QIcon::On));
    } else {
        BaseLocationItem::paint(painter, option, widget);
    }
}

void FriendLocationItem::setPartOfGroup(bool value)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_partOfGroup = value;

    if (value)
        hide();
    else
        show();
}

QString FriendLocationItem::userId() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_userId;
}

void FriendLocationItem::setProfileImage(const QPixmap image, const QUrl &url)
{
    qDebug() << __PRETTY_FUNCTION__;

    setPixmap(image);
    setOffset(-image.width()/2, -image.height()/2);
    m_profileImageUrl = url;
}

QUrl FriendLocationItem::profileImageUrl() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_profileImageUrl;
}

