/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Henri Lampela henri.lampela@ixonos.com
        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef ERROR_H
#define ERROR_H

// Situare errors
namespace SituareError {
    enum errors {
        ERROR_GENERAL = 0,          // an unknown/unspecified error
        ERROR_MISSING_ARGUMENT,     // missing mandatory argument for requested action
        SESSION_EXPIRED = 10,       // situare session credentials expired
        LOGIN_FAILED,               // login to situare service failed
        UPDATE_FAILED,              // location update to situare failed
        DATA_RETRIEVAL_FAILED,      // user/friends list retrieval failed
        ADDRESS_RETRIEVAL_FAILED,   // reversegeo request failed
        IMAGE_DOWNLOAD_FAILED,      // image download failed from facebook
        MAP_IMAGE_DOWNLOAD_FAILED,  // map image download failed from OSM
        GPS_INITIALIZATION_FAILED,  // GPS intialization failed
        INVALID_JSON,               // JSON parsing failed i.e. invalid JSON string
        ERROR_ROUTING_FAILED,       // routing failed
        ERROR_LOCATION_SEARCH_FAILED
    };
}

// Error contexts
namespace ErrorContext {
    enum context {
        SITUARE = 0,                // situare context
        NETWORK                     // QNetworkReply context
    };
}

#endif // ERROR_H
