#ifndef CONTACTMANAGER_H
#define CONTACTMANAGER_H

#include <QObject>
#include <QHash>

class ContactManagerPrivate;

/**
* @brief Manages phone address book contacts.
*/
class ContactManager : public QObject
{
    Q_OBJECT
public:
    /**
    * @brief Constructor
    *
    * @param parent QObject
    */
    ContactManager(QObject *parent = 0);

/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
    /**
    * @brief Returns contact's guid from contact's facebook ID.
    *
    * @param facebookId contact's facebook ID
    * @return contact guid
    */
    QString contactGuid(const QString &facebookId) const;

    /**
    * @brief Requests contact guids.
    *
    * Guid is a globally unique ID of a contact, which can be used with
    * other datastores.
    */
    void requestContactGuids();

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    ContactManagerPrivate *m_contactManagerPrivate; ///< ContactManagerPrivate
};

#endif // CONTACTMANAGER_H
