/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef APPLICATION_H
#define APPLICATION_H

#include <QApplication>

/**
* @brief Application class is a subclass of QApplication
*
* This class handles X11 events
*/
class Application : public QApplication
{
    Q_OBJECT

public:
    /**
    * @brief Constructor
    *
    * @param argc number of arguments
    * @param argv arguments
    */
    Application(int &argc, char **argv);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Registers window
    *
    * @param wId window id
    */
    void registerWindow(WId wId);

    /**
    * @brief Unregisters window
    *
    * @param wId window id
    */
    void unregisterWindow(WId wId);

private:
    /**
    * @brief Return active window
    *
    * @param display display
    * @param rootWindow rootwindow
    * @return WId window id
    */
    WId activeDesktopWindow(Display *display, WId rootWindow);

    /**
    * @brief Event filter for window
    *
    * @param event window event
    * @return bool Return true if you want to stop the event from being processed.
    *         Return false for normal event dispatching
    */
    bool x11EventFilter(XEvent *event);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signal is emitted when full screen button must be invoked and it's hiding timer
             cleared.
    *
    * Signal is emitted when user interacts with keyboard or with mouse/finger, or when the
    * main window is exposed.
    */
    void showFullScreenButton();

    /**
    * @brief Emitted when topmost window is changed
    *
    * @param mainWindowIsTopmost True if MainWindow is the topmost window
    */
    void topmostWindowChanged(bool mainWindowIsTopmost);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    bool m_topmost;             ///< Flag for topmost

    QList<WId> m_windows;       ///< List of window ids
};

#endif // APPLICATION_H
