/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QtTest/QtTest>
#include <QtCore>
#include "ui/sidepanel.h"

class TestSidePanel : public QObject
{
    Q_OBJECT

private slots:
    void testPanelTypes();
    void testPanelToggling();
};

void TestSidePanel::testPanelTypes()
{
    SidePanel *testPanel = new SidePanel();
    testPanel->setType(SidePanel::UserPanel);
    QCOMPARE(testPanel->objectName(), QString("UserPanel"));
    delete testPanel;

    testPanel = new SidePanel();
    testPanel->setType(SidePanel::FriendPanel);
    QCOMPARE(testPanel->objectName(), QString("FriendPanel"));
    delete testPanel;
}

void TestSidePanel::testPanelToggling()
{
    SidePanel *testPanel = new SidePanel();
    testPanel->setType(SidePanel::UserPanel);
    QSignalSpy toggleSpy(testPanel, SIGNAL(toggleState()));

    QVERIFY(toggleSpy.isValid());
    QCOMPARE(toggleSpy.count(),0);

    //Try to close the panel. As the panel is closed, no toggle signal should be sent
    testPanel->closePanel();
    QTest::qWait(1);
    QCOMPARE(toggleSpy.count(),0);

    //Now try to open the panel. Signal should be sent
    testPanel->openPanel();
    QTest::qWait(1);
    QCOMPARE(toggleSpy.count(), 1);

    //Now try to open the panel again. Signal should not be sent as the panel is already open
    testPanel->openPanel();
    QTest::qWait(1);
    QCOMPARE(toggleSpy.count(), 1);

    //Now try to close the panel, signal should be sent
    testPanel->closePanel();
    QTest::qWait(1);
    QCOMPARE(toggleSpy.count(), 2);
    delete testPanel;
}
QTEST_MAIN(TestSidePanel)
#include "testsidepanel.moc"
