/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef PANELSIDEBAR_H
#define PANELSIDEBAR_H

#include <QPaintEvent>
#include <QPixmap>
#include <QRect>
#include <QSize>
#include <QWidget>

#include "panelcommon.h"

/**
 * @brief Generic class for drawing sidebar anchors at the side of the screen
 *
 * @author Kaj Wallin - kaj.wallin (at) ixonos.com
 * @author Pekka Nissinen - pekka.nissinen@ixonos.com
 *
 * @class PanelSideBar panelsidebar.h "ui/panelsidebar.h"
 */
class PanelSideBar : public QWidget
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     * @param side Qstring for the sidebar location. Accepts "left" and "right"
     */
    PanelSideBar(QWidget *parent = 0, Side side = LEFT);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Draws stylesheet used in this class.
     *
     * @param * QPaintEvent unused
     */
    void paintEvent(QPaintEvent *);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
     * @brief Slot to redraw the side bar after window resize event
     *
     * @param size Size of the new window
     */
    void resizeSideBar(const QSize &size);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QPixmap m_menuDropShadowTile;   ///< Pixmap for menu drop shadow
    QPixmap m_panelMiddleTile;      ///< Pixmap for side bar middle tile
    QPixmap m_panelTile;            ///< Pixmap for side bar tile
    QRect topRect;      ///< Rect for side bar top
    QRect middleRect;   ///< Rect for side bar middle
    QRect bottomRect;   ///< Rect for side bar bottom
};

#endif // PANELSIDEBAR_H
