 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */

#include "friendlistpanel.h"
#include "friendlistview.h"
#include "friendlistitem.h"
#include "panelcommon.h"
#include "sidepanel.h"

FriendListPanel::FriendListPanel(QWidget *parent)
    : SidePanel(parent)
{
    qDebug() << __PRETTY_FUNCTION__;
    setType(SidePanel::FriendPanel);

    QHBoxLayout *filterLayout = new QHBoxLayout;
    filterLayout->setContentsMargins(FRIENDPANEL_FILTER_MARGIN_LEFT, 0,
                                     FRIENDPANEL_FILTER_MARGIN_RIGHT, 0);
    m_friendListHeaderWidget = new QWidget();
    m_friendListHeaderWidget->setLayout(filterLayout);
    m_friendListHeaderWidget->setAutoFillBackground(true);
    QPalette labelPalette = m_friendListHeaderWidget->palette();
    labelPalette.setColor(QPalette::Background, Qt::black);
    m_friendListHeaderWidget->setPalette(labelPalette);
    m_friendListHeaderWidget->hide();
    m_friendListLabel = new QLabel(this);
    m_clearFilterButton = new QPushButton(tr("Show all"));
    filterLayout->addWidget(m_friendListLabel);
    filterLayout->addWidget(m_clearFilterButton);
    m_panelVBox->addWidget(m_friendListHeaderWidget);

    QHBoxLayout *friendListLayout =  new QHBoxLayout;
    friendListLayout->setContentsMargins(FRIENDPANEL_MARGIN_LEFT, FRIENDPANEL_MARGIN_TOP,
                                         FRIENDPANEL_MARGIN_RIGHT, FRIENDPANEL_MARGIN_BOTTOM);
    m_friendListView = new FriendListView(this);
    QScrollArea *friendListScroll = new QScrollArea(this);
    friendListScroll->setWidgetResizable(false);
    friendListScroll->setWidget(m_friendListView);
    friendListScroll->viewport()->setAutoFillBackground(false);
    friendListScroll->widget()->setAutoFillBackground(false);
    friendListLayout->addWidget(friendListScroll);
    m_panelVBox->addLayout(friendListLayout);

    connect(m_clearFilterButton, SIGNAL(clicked()),
            this, SLOT(clearFriendListFilter()));
    connect(this, SIGNAL(panelOpened()),
            this, SLOT(clearFriendListFilter()));
}

void FriendListPanel::friendInfoReceived(QList<User *> &friendList)
{
    qDebug() << __PRETTY_FUNCTION__;

    QStringList newUserIDs;

    foreach (User *user, friendList) {
        FriendListItem *item = 0;
        if (!m_friendListView->contains(user->userId())) {
            item = new FriendListItem(m_friendListView);
            item->setData(user);
            m_friendListView->addWidget(user->userId(), item);

            connect(item, SIGNAL(findFriend(QPointF)),
                this, SIGNAL(findFriend(QPointF)));
        }
        else {
            item = m_friendListView->takeWidgetFromView(user->userId());
            if (item) {
                item->setData(user);
                m_friendListView->addWidgetToView(item);
            }
        }

        newUserIDs.append(user->userId());
    }

    m_friendListView->clearUnused(newUserIDs);
}

void FriendListPanel::clearFriendListFilter()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_friendListHeaderWidget->hide();
    m_friendListView->clearFilter();
}

void FriendListPanel::showFriendsInList(const QList<QString> &userIDs)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_friendListLabel->setText(tr("Selected: %1").arg(userIDs.count()));

    openPanel();
    m_friendListHeaderWidget->show();
    m_friendListView->filter(userIDs);
}
