/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Ville Tiensuu - ville.tiensuu@ixonos.com
       Sami Rämö - sami.ramo@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef FRIENDLOCATIONITEM_H
#define FRIENDLOCATIONITEM_H


#include <QObject>
#include <QUrl>
#include <QPixmap>
#include <QPainter>

#include "baselocationitem.h"

/**
 * @brief Class that shows friends location icons on the map
 *
 * @class FriendLocationItem friendlocationitem.h "map/friendlocationitem.h"
 * @author Ville Tiensuu.
 * @author Sami Rämö - sami.ramo@ixonos.com
 */
class FriendLocationItem : public BaseLocationItem
{
    Q_OBJECT

public:
    /**
     * @brief Constructor of FriendLocationItem
     *
     * Sets user ID
     * Sets position to UNDEFINED.
     * Sets default Z-value.
     * Sets item to ignore transformations. this feature is needed to make icon on the map
     * immune to scaling
     *
     * @param userId Used ID of the friend
     * @param parent Parent
     */
    FriendLocationItem(const QString &userId, QObject *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
public:
    /**
     * @brief Paints item pixmap.
     *
     * Paints normal or highlighted pixmap image.
     *
     * @param painter QPainter
     * @param option QStyleOptionGraphicsItem
     * @param widget QWidget
     */
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
     * @brief Is item part of any group
     *
     * @return True if item is part of group, otherwise false.
     */
    bool isPartOfGroup() const;

    /**
     * @brief getter for friends profile image URL
     *
     * @return QUrl friends profile images URL
     */
    QUrl profileImageUrl() const;

    /**
     * @brief Set profile image and it's URL for friend
     *
     * Also offset is set matching new image dimensions.
     *
     * @param image New profile image
     * @param url URL of the new profile image
     */
    void setProfileImage(const QPixmap image, const QUrl &url);

    /**
     * @brief Set value for m_partOfGroup flag
     *
     * @param value New value
     */
    void setPartOfGroup(bool value);

    /**
     * @brief getter for m_userId
     *
     * @return QString friends user identity
     */
    QString userId() const;

protected:
    /**
     * @brief method that detects when friend icon is moved
     *
     * Disables m_clickEvent flag if press and release where not
     * in same area.
     *
     * @param event detects the mouse move (or touch in Maemo)
     */
    void mouseMoveEvent(QGraphicsSceneMouseEvent *event);

    /**
     * @brief method that detects when friend icon is clicked
     *
     * @param event detects the mouse click (or touch in Maemo)
     */
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

    /**
     * @brief method that detects when friend icon press is released
     *
     * @param event detects the mouse release event (or touch in Maemo)
     */
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
 signals:
     /**
      * @brief Signal is emitted when l item is clicked.
      *
      * @param userIDs list of friends user IDs in the group
      */
     void locationItemClicked(const QList<QString> &userIDs);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    bool m_partOfGroup; ///< Flag to mark if item is part of any group
    const QString m_userId; ///< Friends user ID. Can't be changed afterwards
    QUrl m_profileImageUrl; ///< Friends Facebook profile image URL
    QPointF m_mousePressPosition; ///< Mouse press position
    bool m_clickEvent;          ///< Flag to mark click event
};

#endif // FRIENDLOCATIONITEM_H
