/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Ville Tiensuu - ville.tiensuu@ixonos.com
       Sami Rämö - sami.ramo@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef BASELOCATIONITEM_H
#define BASELOCATIONITEM_H

#include <QGraphicsPixmapItem>


/**
 * @brief Baseclass for showing own and friends locations on the map.
 *
 * @author Ville Tiensuu - ville.tiensuu@ixonos.com
 * @author Sami Rämö - sami.ramo@ixonos.com
 */
class BaseLocationItem : public QGraphicsPixmapItem, public QObject
{

public:
    /**
     * @brief Constructor of BaseLocationItem.
     *        Sets parent.
     *
     * @param parent
     */
    BaseLocationItem(QObject *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
     * @brief Return item rect transformed to given zoom level
     *
     * Because of using ItemIgnoresTransformations, and not scaling the item, the default
     * sceneBoundingRect can't be used because it always returns the lowest map tile level scene
     * bounding rect. This method does return rect scaled to given zoom level.
     *
     * @param zoomLevel Zoom level for which the sceneBoundingRect should be transformed
     * @return sceneBoundingRect transformed to given zoom level
     */
    QRect sceneTransformedBoundingRect(int zoomLevel) const;
};


#endif // BASELOCATIONITEM_H
