/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef FRIENDLISTVIEW_H
#define FRIENDLISTVIEW_H

#include <QWidget>
#include <QHash>

class QVBoxLayout;
class QLabel;
class User;
class FriendListItem;

/**
* @brief FriendListView shows items in list.
*
*/
class FriendListView : public QWidget
{
    Q_OBJECT

public:
    /**
    * @brief Constructor.
    *
    * @param parent parent widget
    */
    FriendListView(QWidget *parent = 0);

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Add widget to view and widget list.
    *
    * @param key user ID
    * @param widget widget to add to list
    */
    void addWidget(const QString &key, QWidget *widget);

    /**
    * @brief Adds widget to view.
    *
    * @param item FriendListItem
    */
    void addWidgetToView(FriendListItem *item);

    /**
    * @brief Clear unused widgets from view.
    *
    * Clears items which are not in user ID's list from the view and widget list.
    *
    * @param userIDs list of new user ID's.
    */
    void clearUnused(const QStringList &userIDs);

    /**
    * @brief Clears filtering from list.
    *
    * Calls show to all widgets.
    */
    void clearFilter();

    /**
    * @brief Checks if view contains widget with userID.
    *
    * @param userID user's ID
    * @return true if view contains widget, false otherwise
    */
    bool contains(const QString &userID);

    /**
    * @brief Sets filter to list.
    *
    * Hide all widgets that are not in the userIDs list.
    *
    * @param userIDs user ID's to widgets that are shown
    */
    void filter(const QList<QString> &userIDs);

    /**
    * @brief Takes widget from view.
    *
    * Widget is not deleted.
    *
    * @param userID user's ID
    * @return FriendListItem
    */
    FriendListItem *takeWidgetFromView(const QString &userID);

    /**
    * @brief Returns FriendListItem with userID.
    *
    * @param userID user's ID
    * @return FriendListItem
    */
    FriendListItem *widget(const QString &userID);

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    QVBoxLayout *m_friendListLayout;    ///< Layout for this view
    QHash<QString, QWidget *> m_widgets;  ///< List of widgets in this view. Key = user ID
};

#endif // FRIENDLISTVIEW_H
