/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>

#include <icd/dbus_api.h>

#include "networkhandler.h"
#include "networkhandlerprivate.h"

const int CONNECTION_STATE_INDEX = 7;

static QDBusConnection dBusConnection = QDBusConnection::systemBus();

NetworkHandlerPrivate::NetworkHandlerPrivate(QObject *parent)
    : QObject(parent),
      m_connected(false),
      m_connecting(false)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_parent = static_cast<NetworkHandler*>(parent);

    dBusInterface = new QDBusInterface(ICD_DBUS_API_INTERFACE, ICD_DBUS_API_PATH,
                                       ICD_DBUS_API_INTERFACE, dBusConnection);

    dBusConnection.connect(ICD_DBUS_API_INTERFACE, ICD_DBUS_API_PATH, ICD_DBUS_API_INTERFACE,
                           ICD_DBUS_API_STATE_SIG,
                           this, SLOT(stateChanged(const QDBusMessage &)));

    state();
}

void NetworkHandlerPrivate::stateChanged(const QDBusMessage &message)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (message.arguments().count() > CONNECTION_STATE_INDEX) {

        bool conversionOk;
        int connectionState = message.arguments().at(CONNECTION_STATE_INDEX).toInt(&conversionOk);

        if (conversionOk) {
            if ((connectionState == ICD_STATE_DISCONNECTED) && (isConnected())) {
                m_connected = false;
                m_connecting = false;
                emit m_parent->disconnected();
            }
            if (connectionState == ICD_STATE_DISCONNECTING) {
                m_connecting = false;
            }
            else if ((connectionState == ICD_STATE_CONNECTED) &&(!isConnected())) {
                m_connected = true;
                m_connecting = false;
                emit m_parent->connected();
            }
        }
    }
}

void NetworkHandlerPrivate::connect()
{
    qDebug() << __PRETTY_FUNCTION__;

    if (!m_connecting && !m_connected) {
        m_connecting = true;
        dBusInterface->call(ICD_DBUS_API_CONNECT_REQ,
                            QVariant((unsigned int)ICD_CONNECTION_FLAG_USER_EVENT));
    }
}

void NetworkHandlerPrivate::disconnect()
{
    qDebug() << __PRETTY_FUNCTION__;

    dBusInterface->call(ICD_DBUS_API_DISCONNECT_REQ,
                        QVariant((unsigned int)ICD_CONNECTION_FLAG_USER_EVENT));
}

bool NetworkHandlerPrivate::isConnected()
{
    qDebug() << __PRETTY_FUNCTION__ << m_connected;

    return m_connected;
}

void NetworkHandlerPrivate::state()
{
    qDebug() << __PRETTY_FUNCTION__;

    dBusInterface->call(ICD_DBUS_API_STATE_REQ);
}
