/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef GEOCOORDINATE_H
#define GEOCOORDINATE_H

/**
* @brief GeoCoordinate class stores latitude and longitude.
*/
class GeoCoordinate
{
public:
    /**
    * @brief Constructor.
    */
    GeoCoordinate();

    /**
    * @brief Constructor.
    *
    * @param latitude latitude value
    * @param longitude longitude value
    */
    GeoCoordinate(double latitude, double longitude);

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
    /**
    * @brief Returns is coordinate valid.
    *
    * @return true if coordinate is valid, false otherwise
    */
    bool isValid();

    /**
    * @brief Returns latitude.
    *
    * @return latitude value
    */
    double latitude() const;

    /**
    * @brief Returns longitude.
    *
    * @return longitude value
    */
    double longitude() const;

    /**
    * @brief Sets latitude.
    *
    * @param latitude value
    */
    void setLatitude(double latitude);

    /**
    * @brief Sets longitude.
    *
    * @param longitude value
    */
    void setLongitude(double longitude);

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    double m_latitude;  ///< Latitude value
    double m_longitude; ///< Longitude value
};

#endif // GEOCOORDINATE_H
