/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef GPSPOSITIONPRIVATESTUB_H
#define GPSPOSITIONPRIVATESTUB_H

#include <QObject>

#include "gpsposition.h"

class QPointF;
class QString;

/**
* @brief GPSPositionPrivate class does nothing.
*
* Class is used when compiling in desktop.
*/
class GPSPositionPrivate : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Constructor.
    *
    * @param parent QObject
    */
    GPSPositionPrivate(QObject *parent);

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Returns is GPS initialized.
    *
    * RETURNS FALSE
    * @return true if initialized, false otherwise
    */
    bool isInitialized();

    /**
    * @brief Checks if GPS is running.
    *
    * RETURNS FALSE.
    * @return true if GPS running, false otherwise
    */
    bool isRunning();

    /**
    * @brief Return last known position.
    */
    QPointF lastPosition();

    /**
    * @brief Informs gps to emit last known position.
    */
    void requestLastPosition();

    /**
    * @brief Set GPS update interval.
    *
    * DOES NOTHING.
    * @return interval interval in milliseconds
    */
    void setUpdateInterval(int interval);

    /**
    * @brief Set GPS mode.
    *
    * DOES NOTHING
    * @param mode GPS mode
    * @param filePath file path to NMEA file if simulation mode is used
    */
    void setMode(GPSPosition::Mode mode, const QString &filePath = 0);

    /**
    * @brief Start GPS.
    *
    * Emits GPS initalization error.
    */
    void start();

    /**
    * @brief Stop GPS.
    *
    * DOES NOTHING.
    */
    void stop();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    GPSPosition *m_parent;                      ///< Parent object
};

#endif // GPSPOSITIONMOCKUP_H
