#ifndef TIMEDSTATE_H
#define TIMEDSTATE_H

#include <QState>
#include <QBasicTimer>
#include <QElapsedTimer>

class TimedState : public QState
{
    void onEntry(QEvent *event);
    void onExit(QEvent *event);
    void timerEvent(QTimerEvent *);

    QBasicTimer m_timer;
    QElapsedTimer m_elapsedTimer;
    QString m_name;
    int m_timeout;

public:
    TimedState(const QString& name, int timeout, QState* parent = 0);
    void setTimeout(int timeout);
};

#endif // TIMEDSTATE_H
