#include "setupdialog.h"
#include "ui_setupdialog.h"

#include "constants.h"

#include <QSettings>

SetupDialog::SetupDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SetupDialog)
{
    ui->setupUi(this);
}

SetupDialog::~SetupDialog()
{
    delete ui;
}

void SetupDialog::save()
{
    QSettings settings;
    settings.setValue(SETUP_XBMC_SERVER, ui->xbmcServerEdit->text());
    settings.setValue(SETUP_XBMC_PORT, ui->xbmcPortEdit->text());

    settings.setValue(SETUP_XBMC_REQUIRES_AUTHENTICATION, ui->xbmcRequiresAuthenticationBox->isChecked());
    settings.setValue(SETUP_XBMC_USERNAME, ui->xbmcUsernameEdit->text());
    settings.setValue(SETUP_XBMC_PASSWORD, ui->xbmcPasswordEdit->text());

    settings.setValue(SETUP_SCREEN_DISABLE_SCREENSAVER, ui->screenDisableScreensaverBox->isChecked());
    settings.setValue(SETUP_SCREEN_DIM_TIMEOUT, ui->screenDimTimeoutSlider->value());
    settings.setValue(SETUP_SCREEN_DIM_PERCENT, ui->screenDimPercentSlider->value());

    settings.setValue(SETUP_NOTIFICATION_TIMEOUT, ui->notificationTimeoutSlider->value());
}

void SetupDialog::load()
{
    QSettings settings;
    ui->xbmcServerEdit->setText(settings.value(SETUP_XBMC_SERVER, SETUP_XBMC_SERVER_DEFAULT).toString());
    ui->xbmcPortEdit->setText(settings.value(SETUP_XBMC_PORT, SETUP_XBMC_PORT_DEFAULT).toString());

    ui->xbmcRequiresAuthenticationBox->setChecked(settings.value(SETUP_XBMC_REQUIRES_AUTHENTICATION, SETUP_XBMC_REQUIRES_AUTHENTICATION_DEFAULT).toBool());
    ui->xbmcUsernameEdit->setText(settings.value(SETUP_XBMC_USERNAME, SETUP_XBMC_USERNAME_DEFAULT).toString());
    ui->xbmcPasswordEdit->setText(settings.value(SETUP_XBMC_PASSWORD, SETUP_XBMC_PASSWORD_DEFAULT).toString());

    ui->screenDisableScreensaverBox->setChecked(settings.value(SETUP_SCREEN_DISABLE_SCREENSAVER, SETUP_SCREEN_DISABLE_SCREENSAVER_DEFAULT).toBool());
    ui->screenDimTimeoutSlider->setValue(settings.value(SETUP_SCREEN_DIM_TIMEOUT, SETUP_SCREEN_DIM_TIMEOUT_DEFAULT).toInt());
    ui->screenDimPercentSlider->setValue(settings.value(SETUP_SCREEN_DIM_PERCENT, SETUP_SCREEN_DIM_PERCENT_DEFAULT).toInt());

    ui->notificationTimeoutSlider->setValue(settings.value(SETUP_NOTIFICATION_TIMEOUT, SETUP_NOTIFICATION_TIMEOUT_DEFAULT).toInt());
}
