#include "setupdialog.h"
#include "ui_setupdialog.h"

#include "constants.h"

#include <QSettings>

SetupDialog::SetupDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SetupDialog)
{
    ui->setupUi(this);

    // force label setup
    on_screenDimTimeoutSlider_valueChanged(SETUP_SCREEN_DIM_TIMEOUT_DEFAULT);
    on_screenDimPercentSlider_valueChanged(SETUP_SCREEN_DIM_PERCENT_DEFAULT);
    on_screenLockTimeoutSlider_valueChanged(SETUP_SCREEN_LOCK_TIMEOUT_DEFAULT);
    on_notificationTimeoutSlider_valueChanged(SETUP_NOTIFICATION_TIMEOUT_DEFAULT);
}

SetupDialog::~SetupDialog()
{
    delete ui;
}

void SetupDialog::save()
{
    QSettings settings;
    settings.setValue(SETUP_XBMC_SERVER, ui->xbmcServerEdit->text());
    settings.setValue(SETUP_XBMC_PORT, ui->xbmcPortEdit->text());

    settings.setValue(SETUP_SCREEN_DIM_TIMEOUT, ui->screenDimTimeoutSlider->value());
    settings.setValue(SETUP_SCREEN_DIM_PERCENT, ui->screenDimPercentSlider->value());
    settings.setValue(SETUP_SCREEN_LOCK_TIMEOUT, ui->screenLockTimeoutSlider->value());

    settings.setValue(SETUP_NOTIFICATION_TIMEOUT, ui->notificationTimeoutSlider->value());

    settings.setValue(SETUP_FULLSCREEN_STARTUP, ui->fullScreenCheckBox->isChecked());
}

void SetupDialog::load()
{
    load(false);
}

void SetupDialog::load(bool restore_defaults)
{
    QSettings settings;
    ui->xbmcServerEdit->setText(restore_defaults ?
        SETUP_XBMC_SERVER_DEFAULT :
        settings.value(SETUP_XBMC_SERVER, SETUP_XBMC_SERVER_DEFAULT).toString());

    ui->xbmcPortEdit->setText(restore_defaults ?
        SETUP_XBMC_PORT_DEFAULT :
        settings.value(SETUP_XBMC_PORT, SETUP_XBMC_PORT_DEFAULT).toString());

    ui->screenDimTimeoutSlider->setValue(restore_defaults ?
        SETUP_SCREEN_DIM_TIMEOUT_DEFAULT :
        settings.value(SETUP_SCREEN_DIM_TIMEOUT, SETUP_SCREEN_DIM_TIMEOUT_DEFAULT).toInt());

    ui->screenDimPercentSlider->setValue(restore_defaults ?
        SETUP_SCREEN_DIM_PERCENT_DEFAULT :
        settings.value(SETUP_SCREEN_DIM_PERCENT, SETUP_SCREEN_DIM_PERCENT_DEFAULT).toInt());

    ui->screenLockTimeoutSlider->setValue(restore_defaults ?
        SETUP_SCREEN_LOCK_TIMEOUT_DEFAULT :
        settings.value(SETUP_SCREEN_LOCK_TIMEOUT, SETUP_SCREEN_LOCK_TIMEOUT_DEFAULT).toInt());

    ui->notificationTimeoutSlider->setValue(restore_defaults ?
        SETUP_NOTIFICATION_TIMEOUT_DEFAULT :
        settings.value(SETUP_NOTIFICATION_TIMEOUT, SETUP_NOTIFICATION_TIMEOUT_DEFAULT).toInt());

    ui->fullScreenCheckBox->setChecked(restore_defaults ?
        SETUP_FULLSCREEN_STARTUP_DEFAULT :
        settings.value(SETUP_FULLSCREEN_STARTUP, SETUP_FULLSCREEN_STARTUP_DEFAULT).toBool());
}

void SetupDialog::on_screenDimTimeoutSlider_valueChanged(int value)
{
    ui->screenDimTimeoutLabel->setText(QString("Dim Timeout: %1 min").arg(value));
}

void SetupDialog::on_screenDimPercentSlider_valueChanged(int value)
{
    ui->screenDimPercentLabel->setText(QString("Dim Percent: %1%").arg(value));
}

void SetupDialog::on_screenLockTimeoutSlider_valueChanged(int value)
{
    ui->screenLockTimeoutLabel->setText(QString("Lock Timeout: %1 min").arg(value));
}

void SetupDialog::on_notificationTimeoutSlider_valueChanged(int value)
{
    ui->notificationTimeoutLabel->setText(QString("Notification Timeout: %1 sec").arg(value));
}

void SetupDialog::on_buttonBox_clicked(QAbstractButton* button)
{
    if (ui->buttonBox->standardButton(button) == QDialogButtonBox::RestoreDefaults) {
        load(true);
    }
}
