// checksum 0xfd0b version 0x20001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "setupdialog.h"
#include "legenddialog.h"
#include "xbmc.h"
#include "constants.h"

#include <QSettings>
#include <QCoreApplication>
#include <QDesktopServices>

#if defined(Q_OS_SYMBIAN) && defined(ORIENTATIONLOCK)
#include <eikenv.h>
#include <eikappui.h>
#include <aknenv.h>
#include <aknappui.h>
#endif // Q_OS_SYMBIAN && ORIENTATIONLOCK

#ifdef Q_WS_MAEMO_5
#include "timedstate.h"
#define HAL_SERVICE "org.freedesktop.Hal"
#define HAL_BACKLIGHT_REQUEST_PATH "/org/freedesktop/Hal/devices/computer_backlight"
#define HAL_BACKLIGHT_REQUEST_IF "org.freedesktop.Hal.Device.LaptopPanel"
#define HAL_BACKLIGHT_BRIGHTNESS_REQ "SetBrightness"
#endif // Q_WS_MAEMO_5

#define ACTIVATED_TIMEOUT 500
#define FULL_BRIGHTNESS 100

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , m_ui(new Ui::MainWindow)
    , m_screenLockState(DefaultScreenLockState)
    , m_restartStateMachine(false)
    , m_stateMachine(0)
#ifdef Q_WS_MAEMO_5
    , m_screenSaver(0)
    , m_dbus(QDBusConnection::systemBus())
#endif // Q_WS_MAEMO_5
{
    m_ui->setupUi(this);

    QSettings settings;
    bool enable_custom = settings.value(SETUP_SCREEN_DISABLE_SCREENSAVER, SETUP_SCREEN_DISABLE_SCREENSAVER_DEFAULT).toBool();
    m_ui->actionUseCustomScreensaver->setChecked(enable_custom);

    m_xbmc = new Xbmc();
    m_xbmc->setup();

#ifdef Q_WS_MAEMO_5
    m_dbusMceInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, m_dbus, this);
    m_dbusHalInterface = new QDBusInterface (HAL_SERVICE, HAL_BACKLIGHT_REQUEST_PATH, HAL_BACKLIGHT_REQUEST_IF, m_dbus, this);

    m_dbus.connect(MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF, MCE_TKLOCK_MODE_SIG, this, SLOT(onScreenLockModeChanged(QString)));
#endif

    buildStateMachine();

    m_prevActivatedState = isActiveWindow();
    connect(qApp, SIGNAL(focusChanged(QWidget*,QWidget*)), this, SLOT(onApplicationFocusChanged(QWidget*,QWidget*)));
}

MainWindow::~MainWindow()
{
#ifdef Q_WS_MAEMO_5
    // revert to default screensaver behavior
    enableCustomScreenSaver(false); // also deletes the m_screenSaver
    setScreenBrightness(100);

    delete m_dbusHalInterface;
    delete m_dbusMceInterface;
#endif

    delete m_stateMachine;
    delete m_xbmc;
    delete m_ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#ifdef Q_OS_SYMBIAN
    if (orientation != ScreenOrientationAuto) {
#if defined(ORIENTATIONLOCK)
        const CAknAppUiBase::TAppUiOrientation uiOrientation =
                (orientation == ScreenOrientationLockPortrait) ? CAknAppUi::EAppUiOrientationPortrait
                    : CAknAppUi::EAppUiOrientationLandscape;
        CAknAppUi* appUi = dynamic_cast<CAknAppUi*> (CEikonEnv::Static()->AppUi());
        TRAPD(error,
            if (appUi)
                appUi->SetOrientationL(uiOrientation);
        );
        Q_UNUSED(error)
#else // ORIENTATIONLOCK
        qWarning("'ORIENTATIONLOCK' needs to be defined on Symbian when locking the orientation.");
#endif // ORIENTATIONLOCK
    }
#elif defined(Q_WS_MAEMO_5)
    Qt::WidgetAttribute attribute;
    switch (orientation) {
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_Maemo5PortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_Maemo5LandscapeOrientation;
        break;
    case ScreenOrientationAuto:
    default:
        attribute = Qt::WA_Maemo5AutoOrientation;
        break;
    }
    setAttribute(attribute, true);
#else // Q_OS_SYMBIAN
    Q_UNUSED(orientation);
#endif // Q_OS_SYMBIAN
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    QSettings settings;
    bool fullscreen = settings.value(SETUP_FULLSCREEN_STARTUP, SETUP_FULLSCREEN_STARTUP_DEFAULT).toBool();
    if (fullscreen)
        showFullScreen();
    else
        showMaximized();
#else
    show();
#endif
}

void MainWindow::on_actionSetup_triggered()
{
    SetupDialog dialog;
    dialog.load();
    if(dialog.exec() == QDialog::Accepted) {
        dialog.save();

        m_xbmc->setup();
        m_restartStateMachine = 0;
        if (m_stateMachine) {
            m_stateMachine->stop();
        }
    }
}

void MainWindow::on_rightBtn_clicked()
{
    m_xbmc->actionRight();
}

void MainWindow::on_leftBtn_clicked()
{
    m_xbmc->actionLeft();
}

void MainWindow::on_upBtn_clicked()
{
    m_xbmc->actionUp();
}

void MainWindow::on_downBtn_clicked()
{
    m_xbmc->actionDown();
}

void MainWindow::on_playBtn_clicked()
{
    m_xbmc->actionPlay();
}

void MainWindow::on_muteBtn_clicked()
{
    m_xbmc->actionMute();
}

void MainWindow::on_volumeUpBtn_clicked()
{
    m_xbmc->actionVolumeUp();
}

void MainWindow::on_volumeDownBtn_clicked()
{
    m_xbmc->actionVolumeDown();
}

void MainWindow::on_nextSubtitleBtn_clicked()
{
    m_xbmc->actionNextSubtitle();
}

void MainWindow::on_nextLanguageBtn_clicked()
{
    m_xbmc->actionNextLanguage();
}

void MainWindow::on_selectButton_clicked()
{
    m_xbmc->actionSelect();
}

void MainWindow::on_stopBtn_clicked()
{
    m_xbmc->actionStop();
}

void MainWindow::on_showGuiBtn_clicked()
{
    m_xbmc->actionShowGui();
}

void MainWindow::on_contextMenuBtn_clicked()
{
    m_xbmc->actionContextMenu();
}

void MainWindow::on_sendEscKeyBtn_clicked()
{
    m_xbmc->actionSendKeyEsc();
}

void MainWindow::on_backBtn_clicked()
{
    m_xbmc->actionBack();
}

void MainWindow::enableCustomScreenSaver(bool enabled)
{
#ifdef Q_WS_MAEMO_5
    if (enabled) {
        if (m_screenSaver == 0) {
            m_screenSaver = new QSystemScreenSaver(this);
            if (m_screenSaver->setScreenSaverInhibit()) {
                qDebug("enableCustomScreenSaver: enabled custom screensaver");
            }
        }
    } else {
        if (m_screenSaver) {
            delete m_screenSaver;
            m_screenSaver = 0;
            qDebug("enableCustomScreen: default screensaver restored");
        }
    }
#endif
}

void MainWindow::buildStateMachine()
{
    QSettings settings;
    int dim_timeout = SCREEN_DIM_TIMEOUT_MULTIPLIER * settings.value(SETUP_SCREEN_DIM_TIMEOUT, SETUP_SCREEN_DIM_TIMEOUT_DEFAULT).toInt();
    int lock_timeout = SCREEN_LOCK_TIMEOUT_MULTIPLIER * settings.value(SETUP_SCREEN_DIM_TIMEOUT, SETUP_SCREEN_DIM_TIMEOUT_DEFAULT).toInt();
    bool enable_custom = settings.value(SETUP_SCREEN_DISABLE_SCREENSAVER, SETUP_SCREEN_DISABLE_SCREENSAVER_DEFAULT).toBool();

    // define states
    m_defaultState = new NamedState("default");
    m_customState = new NamedState("custom");
    m_customUnlockedState = new NamedState("custom > unlocked", m_customState);
    m_customLockedState = new NamedState("custom > locked", m_customState);
    m_customUnlockedNormalState = new TimedState("custom > unlocked > normal", dim_timeout, m_customUnlockedState);
    m_customUnlockedDimState = new TimedState("custom > unlocked > dim", lock_timeout, m_customUnlockedState);

    m_customHistoryState = new QHistoryState(m_customState);
    m_deactivatedState = new NamedState("deactivated");

    // define initial substates
    m_customState->setInitialState(m_customUnlockedState);
    m_customUnlockedState->setInitialState(m_customUnlockedNormalState);

    // define transitions
    QList<QAbstractButton*> button_list;
    button_list
            << m_ui->nextSubtitleBtn
            << m_ui->nextLanguageBtn
            << m_ui->showGuiBtn
            << m_ui->contextMenuBtn
            << m_ui->sendEscKeyBtn
            << m_ui->volumeUpBtn
            << m_ui->volumeDownBtn
            << m_ui->muteBtn
            << m_ui->upBtn
            << m_ui->downBtn
            << m_ui->leftBtn
            << m_ui->rightBtn
            << m_ui->playBtn
            << m_ui->stopBtn
            << m_ui->selectButton;
    foreach(QAbstractButton* button, button_list) {
        m_customUnlockedState->addTransition(button, SIGNAL(clicked()), m_customUnlockedState);
    }

    m_customLockedState->addTransition(this, SIGNAL(screenUnlocked()), m_customUnlockedState);
    m_customUnlockedState->addTransition(this, SIGNAL(screenLocked()), m_customLockedState);

    m_customUnlockedNormalState->addTransition(m_customUnlockedNormalState, SIGNAL(timeout()), m_customUnlockedDimState);
    m_customUnlockedDimState->addTransition(m_customUnlockedDimState, SIGNAL(timeout()), m_customLockedState);

    m_deactivatedState->addTransition(this, SIGNAL(activated()), m_customHistoryState);
    m_customState->addTransition(this, SIGNAL(deactivated()), m_deactivatedState);

    // add states to the state machine
    m_stateMachine = new QStateMachine(this);

    m_stateMachine->addState(m_defaultState);
    m_stateMachine->addState(m_customState);
    m_stateMachine->addState(m_deactivatedState);

    m_stateMachine->setInitialState(enable_custom ? m_customState : m_defaultState);

    // connect states' entered signals to local slots
    connect(m_defaultState, SIGNAL(entered()), this, SLOT(onDefaultStateEntered()));
    connect(m_deactivatedState, SIGNAL(entered()), this, SLOT(onDeactivatedStateEntered()));
    connect(m_customUnlockedState, SIGNAL(entered()), this, SLOT(onCustomUnlockedStateEntered()));
    connect(m_customUnlockedNormalState, SIGNAL(entered()), this, SLOT(onCustomUnlockedNormalStateEntered()));
    connect(m_customUnlockedDimState, SIGNAL(entered()), this, SLOT(onCustomUnlockedDimmedStateEntered()));
    connect(m_customLockedState, SIGNAL(entered()), this, SLOT(onCustomLockedStateEntered()));

    connect(m_stateMachine, SIGNAL(stopped()), this, SLOT(onStateMachineStopped()));

    m_stateMachine->start();
}

void MainWindow::setScreenBrightness(int value)
{
#ifdef Q_WS_MAEMO_5
    m_dbusHalInterface->call(HAL_BACKLIGHT_BRIGHTNESS_REQ, value);
#endif
}

void MainWindow::onScreenLockModeChanged(const QString &state)
{
#ifdef Q_WS_MAEMO_5
    if (m_screenLockState != DefaultScreenLockState) {
        if (state == MCE_TK_LOCKED && m_screenLockState == UnlockedScreenLockState) {
            qDebug("onScreenLockModeChanged: emiting screenLocked...");
            emit screenLocked();
        } else if (state == MCE_TK_UNLOCKED && m_screenLockState == LockedScreenLockState) {
            qDebug("onScreenLockModeChanged: emiting screenUnlocked...");
            emit screenUnlocked();
        }
    }
#endif
}

void MainWindow::on_actionOpenWebHomepage_triggered()
{
    QDesktopServices::openUrl(QUrl(HOMEPAGE_URL, QUrl::TolerantMode));
}

void MainWindow::onApplicationFocusChanged(QWidget */*old*/, QWidget */*now*/)
{
    bool current_state = isActiveWindow();
    if (current_state != m_prevActivatedState) {
        m_prevActivatedState = current_state;
        if (current_state) {
            qDebug("MainWindow::onApplicationFocusChanged: emiting activated (window is focused) ...");
            emit activated();
        } else {
            qDebug("MainWindow::onApplicationFocusChanged: emiting deactivated (window has lost foscus) ...");
            emit deactivated();
        }
    }
}

void MainWindow::on_actionButtonLegend_triggered()
{
    LegendDialog dialog;
    dialog.exec();
}

void MainWindow::mouseDoubleClickEvent(QMouseEvent */*event*/)
{
    if (isFullScreen())
        showMaximized();
    else
        showFullScreen();
}

void MainWindow::onDefaultStateEntered()
{
    m_screenLockState = DefaultScreenLockState;
    enableCustomScreenSaver(false);
    setScreenBrightness(FULL_BRIGHTNESS);
}

void MainWindow::onDeactivatedStateEntered()
{
    m_screenLockState = DefaultScreenLockState;
    enableCustomScreenSaver(false);
    setScreenBrightness(FULL_BRIGHTNESS);
}

void MainWindow::onCustomUnlockedStateEntered()
{
    m_screenLockState = UnlockedScreenLockState;
    enableCustomScreenSaver(true);
}

void MainWindow::onCustomUnlockedNormalStateEntered()
{
    QSettings settings;

    int timeout = SCREEN_DIM_TIMEOUT_MULTIPLIER * settings.value(SETUP_SCREEN_DIM_TIMEOUT, SETUP_SCREEN_DIM_TIMEOUT_DEFAULT).toInt();
    m_customUnlockedNormalState->setTimeout(timeout);
    setScreenBrightness(FULL_BRIGHTNESS);
}

void MainWindow::onCustomUnlockedDimmedStateEntered()
{
    QSettings settings;

    int percent = settings.value(SETUP_SCREEN_DIM_PERCENT, SETUP_SCREEN_DIM_PERCENT_DEFAULT).toInt();
    int timeout = SCREEN_LOCK_TIMEOUT_MULTIPLIER * settings.value(SETUP_SCREEN_LOCK_TIMEOUT, SETUP_SCREEN_LOCK_TIMEOUT_DEFAULT).toInt();
    setScreenBrightness(percent);
    m_customUnlockedDimState->setTimeout(timeout);
}

void MainWindow::onCustomLockedStateEntered()
{
    m_screenLockState = LockedScreenLockState;

    enableCustomScreenSaver(false);

#ifdef Q_WS_MAEMO_5
    m_dbusMceInterface->call(MCE_TKLOCK_MODE_CHANGE_REQ, MCE_TK_SILENT_LOCKED);
    m_dbusMceInterface->call(MCE_DISPLAY_OFF_REQ);
#endif
}

void MainWindow::on_actionUseCustomScreensaver_toggled(bool enable_custom)
{
    QSettings settings;
    settings.setValue(SETUP_SCREEN_DISABLE_SCREENSAVER, enable_custom);

    if (m_stateMachine) {
        m_restartStateMachine = true;
        m_stateMachine->stop();
    }
}

void MainWindow::onStateMachineStopped()
{
    if (m_restartStateMachine)
        m_restartStateMachine = false;

    if (m_stateMachine) {
        QSettings settings;
        bool enable_custom = settings.value(SETUP_SCREEN_DISABLE_SCREENSAVER, SETUP_SCREEN_DISABLE_SCREENSAVER_DEFAULT).toBool();
        int dim_timeout = SCREEN_DIM_TIMEOUT_MULTIPLIER * settings.value(SETUP_SCREEN_DIM_TIMEOUT, SETUP_SCREEN_DIM_TIMEOUT_DEFAULT).toInt();
        int lock_timeout = SCREEN_LOCK_TIMEOUT_MULTIPLIER * settings.value(SETUP_SCREEN_DIM_TIMEOUT, SETUP_SCREEN_DIM_TIMEOUT_DEFAULT).toInt();
        m_stateMachine->setInitialState(enable_custom ? m_customState : m_defaultState);
        m_customUnlockedNormalState->setTimeout(dim_timeout);
        m_customUnlockedDimState->setTimeout(lock_timeout);
        m_stateMachine->start();
    }
}
