#include <QtGui/QApplication>
#include <QtGui>
#include "mainwindow.h"
#include "qmaemo5homescreenadaptor.h"

#ifdef Q_WS_HILDON
//Q_WS_MAEMO_5
  #include <QHBoxLayout>
  #include <X11/extensions/Xrender.h>
#endif


int main(int argc, char *argv[])
{
    QCoreApplication::setOrganizationName("Jan Bergmann");
    QCoreApplication::setApplicationName("simplenotewidget");
    QApplication::setGraphicsSystem("native");

    QApplication app(argc, argv);

    QSettings *oSettings;
    oSettings = new QSettings("janbergmann", "simplenotewidget");



    QString language = oSettings->value("language", "System").toString();
    QString locale = QLocale::system().name();
    QString sAppDir = QApplication::applicationDirPath();
    QTranslator translator;
    QString sFileName  = "";
    sFileName = "simplenotewidget_" + locale + ".qm";
    if (language != "System")
    {
      sFileName = language;
    }
    QFile f(sAppDir + "/" + sFileName);
    if( f.exists() )
    {
        translator.load(sFileName,sAppDir + "/");
        app.installTranslator(&translator);
    }





    MainWindow w;
#ifdef Q_WS_HILDON
    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&w);
    adaptor->setSettingsAvailable(true);
    QObject::connect(adaptor, SIGNAL(settingsRequested()), &w, SLOT(showSettingsDialog()));
#endif




    QColor cldefault = oSettings->value("bgcolor", QColor(255,255,0)).value<QColor>();
    int bgcoloralpha = oSettings->value("bgcoloralpha", int(200)).toInt();
    cldefault.setAlpha(bgcoloralpha);
    //delete oSettings;


    QPalette pal = w.palette();
    w.setAttribute(Qt::WA_TranslucentBackground);
    w.setAttribute(Qt::WA_NoSystemBackground, false);

    pal.setColor(QPalette::Window, cldefault);
    w.setPalette(pal);
    w.ensurePolished();
    w.setAttribute(Qt::WA_StyledBackground, false);


    w.resize(300, 180);
    w.show();
    return app.exec();
}
