
#include "settingsdlg.h"
#include "ui_settingsdlg.h"
//#include "settingswidget.h"
#include <QVBoxLayout>
#include <QScrollArea>
#include <QWidget>



settingsdlg::settingsdlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::settingsdlg)
{
    ui->setupUi(this);
    this->setWindowTitle("Edit settings");


    QScrollArea *sa = new QScrollArea( this );

    sa->setFrameShadow(QFrame::Plain);
    sa->setFrameShape(QFrame::NoFrame);
    sa->setGeometry(0,0,580,355);
    sa->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
    sa->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    sa->setWidgetResizable(false);

    pw = new SettingsWidget(  sa );

    sa->setWidget( pw );

#ifdef Q_WS_HILDON
       sa->setProperty("FingerScrollable", true);
#endif

}

settingsdlg::~settingsdlg()
{
    delete ui;
}

void settingsdlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void settingsdlg::on_pbCancel_clicked()
{
    this->close();
}

void settingsdlg::on_pbSave_clicked()
{
    pw->DoSave();
    this->close();
}
