#include "dialog.h"
#include "ui_dialog.h"
#include <QFile>
#include <QXmlStreamWriter>
#include <QDateTime>
#include <QDir>
#include <QSettings>



Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);


#ifdef Q_WS_HILDON
  this->setProperty("FingerScrollable", true);
  ui->pbOK->setProperty("FingerScrollable", true);
#endif

  QSettings *oSettings;
  oSettings = new QSettings("janbergmann", "simplenotewidget");
  QColor cldefault = oSettings->value("bgcolor", QColor(255,255,0)).value<QColor>();
  QColor cltextedit = oSettings->value("txtcolor", QColor(0,0,0)).value<QColor>();
  int bgcoloralpha = oSettings->value("bgcoloralpha", int(180)).toInt();
  cldefault.setAlpha(bgcoloralpha);

  int fontSizeIndex = oSettings->value("fontsize", int(3)).toInt();
  QString fontFamilyName = oSettings->value("fontfamily", "Nokia Sans SemiBold").toString();


  this->setWindowTitle("Edit note");
 // this->setWindowModality(Qt::ApplicationModal);
  ui->teMain->setFrameShadow(QFrame::Plain);
  ui->teMain->setFrameShape(QFrame::NoFrame);
  ui->teMain->setPalette(QPalette(cltextedit,cldefault,cldefault,cltextedit,cltextedit,cltextedit,cldefault,cldefault,cldefault));
  ui->teMain->setFontFamily(fontFamilyName);
  switch(fontSizeIndex)
  {
   case 0: fontSizeIndex = 6;
           break;
   case 1: fontSizeIndex = 8;
           break;
   case 2: fontSizeIndex = 10;
           break;
   case 3: fontSizeIndex = 12;
           break;
   case 4: fontSizeIndex = 16;
           break;
   case 5: fontSizeIndex = 24;
           break;
   case 6: fontSizeIndex = 32;
  }

  ui->teMain->setFontPointSize(fontSizeIndex);
  ui->teMain->setWordWrapMode(QTextOption::WrapAtWordBoundaryOrAnywhere);
  ui->teMain->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

  ui->teMain->setText(oSettings->value("note","").toString());


  //delete oSettings;
}

Dialog::~Dialog()
{
    //delete ui;
}

void Dialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Dialog::on_pbOK_clicked()
{
    QDateTime dateTime = QDateTime::currentDateTime();
    QString dateTimeString = dateTime.toString("dd.MM.yyyy   HH:mm");

    QSettings *oSettings;
    oSettings = new QSettings("janbergmann", "simplenotewidget");

    QString sOldText = oSettings->value("note","").toString();
    if (sOldText != ui->teMain->toPlainText())
    {
        oSettings->setValue("note",ui->teMain->toPlainText());
        oSettings->setValue("notedate",dateTimeString);
    }
    delete oSettings;

    this->close();
}

void Dialog::on_pbCancel_clicked()
{
    this->close();
}
