
#include "settingsdlg.h"
#include "ui_settingsdlg.h"
#include "qtcolorcombobox.h"
#include <QSettings>
#include <QScrollArea>
#include <QVariant>



settingsdlg::settingsdlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::settingsdlg)
{
    ui->setupUi(this);
    this->setWindowTitle("Edit settings");






    QSettings *oSettings;
    oSettings = new QSettings("janbergmann", "simplenotewidget");
    QColor cldefault = oSettings->value("bgcolor", QColor(255,255,0)).value<QColor>();
    QColor cltextedit = oSettings->value("txtcolor", QColor(0,0,0)).value<QColor>();
    int iTransparency = oSettings->value("bgcoloralpha", int(180)).toInt();

    int fontSizeIndex = oSettings->value("fontsize", int(1)).toInt();
    QString fontFamilyName = oSettings->value("fontfamily", "Nokia Sans SemiBold").toString();





    int iIndex = 0;
    int iCount = 0;
    for(int i=10; i < 260; i = i + 10)
    {
         QVariant v = i;
         ui->cbtransparency->addItem(v.toString());
         if (i==iTransparency)
         {
             iIndex = iCount;
         }
         iCount++;

    }

    ui->cbtransparency->setCurrentIndex(iIndex);

    ui->cbFontSize->addItem("6");
    ui->cbFontSize->addItem("8");
    ui->cbFontSize->addItem("10");
    ui->cbFontSize->addItem("12");
    ui->cbFontSize->addItem("16");
    ui->cbFontSize->addItem("24");
    ui->cbFontSize->addItem("32");
    ui->cbFontSize->setCurrentIndex(fontSizeIndex);

    ui->fcbFont->setCurrentFont(QFont(fontFamilyName));

    //ui->cbFontFamily->
    //fcbFont
    //cbFontFamily
    delete oSettings;




    cbBG = new QtColorComboBox(this);
    cbBG->setGeometry(260,80,211,61);
    cbBG->setStandardColors();
    cbBG->setCurrentColor(cldefault);
    cbBG->setColorDialogEnabled(false);
    cbBG->setEditText("");


    cbtxt = new QtColorComboBox(this);
    cbtxt->setGeometry(260,150,211,61);
    cbtxt->setStandardColors();
    cbtxt->setCurrentColor(cltextedit);
    cbtxt->setColorDialogEnabled(false);



}

settingsdlg::~settingsdlg()
{
    delete ui;
}

void settingsdlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void settingsdlg::on_pbCancel_clicked()
{
    this->close();
}

void settingsdlg::on_pbSave_clicked()
{


    // if (color.isValid())



    QSettings *oSettings;
    oSettings = new QSettings("janbergmann", "simplenotewidget");

    QColor cldefault = cbBG->currentColor();
    QColor cltextedit = cbtxt->currentColor();


    oSettings->setValue("bgcoloralpha",ui->cbtransparency->currentText());
    oSettings->setValue("bgcolor",cldefault);
    oSettings->setValue("txtcolor",cltextedit);



    oSettings->setValue("fontfamily",ui->fcbFont->currentText());
    oSettings->setValue("fontsize",ui->cbFontSize->currentIndex());

    delete oSettings;


    this->close();
}
