#include "settingsdlg.h"
#include "ui_settingsdlg.h"
#include "qtcolorcombobox.h"
#include <QSettings>



settingsdlg::settingsdlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::settingsdlg)
{
    ui->setupUi(this);




    QSettings oSettings("janbergmann", "simplenotewidget");
    QColor cldefault = oSettings.value("bgcolor", QColor(255,255,0)).value<QColor>();
    QColor cllabelcolor = oSettings.value("lblcolor", QColor(0,0,0)).value<QColor>();
    QColor cltextedit = oSettings.value("txtcolor", QColor(0,0,0)).value<QColor>();








    ui->sbTransparency->setValue(oSettings.value("bgcoloralpha", int(180)).toInt());



    cbBG = new QtColorComboBox(this);
    cbBG->setGeometry(260,80,211,61);
    cbBG->setStandardColors();
    cbBG->setCurrentColor(cldefault);
    cbBG->setColorDialogEnabled(false);


    cbtxt = new QtColorComboBox(this);
    cbtxt->setGeometry(260,150,211,61);
    cbtxt->setStandardColors();
    cbtxt->setCurrentColor(cltextedit);
    cbtxt->setColorDialogEnabled(false);



}

settingsdlg::~settingsdlg()
{
    delete ui;
}

void settingsdlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void settingsdlg::on_pbCancel_clicked()
{
    this->close();
}

void settingsdlg::on_pbSave_clicked()
{


    // if (color.isValid())



    QSettings oSettings("janbergmann", "simplenotewidget");

    QColor cldefault = cbBG->currentColor();
   // QColor cllabelcolor = QColor(ui->leBGColor->text());
    QColor cltextedit = cbtxt->currentColor();


    oSettings.setValue("bgcoloralpha",ui->sbTransparency->value());
    oSettings.setValue("bgcolor",cldefault);
    //oSettings.setValue("lblcolor",cllabelcolor);
    oSettings.setValue("txtcolor",cltextedit);
    this->close();
}
