#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "dialog.h"
#include "settingsdlg.h"

#include <QDateTime>
#include <QMessageBox>
#include <qinputdialog.h>
#include <QStyleOption>
#include <QPainter>
#include <QPaintEvent>
#include <QByteArray>
#include <QCoreApplication>
#include <QPainter>
#include <QPaintEvent>
#include <QMovie>
#include <QDialog>
#include <QSettings>



#ifdef Q_WS_HILDON
    #include <X11/Xlib.h>
    #include <X11/Xatom.h>
    #include <QtGui/QX11Info>
#endif








MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(0, Qt::FramelessWindowHint),
    ui(new Ui::MainWindow)
{
#ifdef Q_WS_HILDON
    QCoreApplication::instance()->setApplicationName("simplenotewidget");
    // Get required atoms
    Atom winTypeAtom = XInternAtom(QX11Info::display(), "_NET_WM_WINDOW_TYPE", false);
    Atom homeAppletAto = XInternAtom(QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", false);
    Atom appletIDAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", false);
    Atom utf8Atom = XInternAtom(QX11Info::display(), "UTF8_STRING", false);
    Atom appletSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", false);

    // Set correct window type
    XChangeProperty(QX11Info::display(), winId(), winTypeAtom, XA_ATOM, 32,
                    PropModeReplace, (unsigned char *) &homeAppletAto, 1);

    // Use application name to fill AppletID
    QByteArray id (QCoreApplication::instance()->applicationName().remove(' ').toUtf8());
    XChangeProperty(QX11Info::display(), winId(), appletIDAtom, utf8Atom, 8,
                    PropModeReplace, (unsigned char *)id.constData(), id.length());

    // Add setting button. This button is shown when hildon-desktop is in edit mode.
    int settings = 0;
    XChangeProperty(QX11Info::display(), winId(), appletSettingAtom, XA_CARDINAL, 32,
                    PropModeReplace, (unsigned char*)&settings, 1);

#endif
    ui->setupUi(this);





   SetupThisUi();



}







#ifdef Q_WS_HILDON
    //Filter show setting requests
    bool MainWindow::x11Event ( XEvent * event )
    {
        static Atom appletShowSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SHOW_SETTINGS", false);
        if (event->xclient.message_type == appletShowSettingAtom )
        {
          //QMessageBox::information(0, "Settings", "will implement this in a future release", QMessageBox::Ok);

            settingsdlg w(0);
            w.setProperty("FingerScrollable", true);
            w.exec();



            SetupThisUi();
            //this->centralWidget()->update();
            //this->centralWidget()->repaint();

          return true;
        }
     return false;
    }
#endif

void MainWindow::SetupThisUi()
{


    QSettings oSettings("janbergmann", "simplenotewidget");
    QColor cldefault = oSettings.value("bgcolor", QColor(255,255,0)).value<QColor>();
    QColor cllabelcolor = oSettings.value("lblcolor", QColor(0,0,0)).value<QColor>();
    QColor cltextedit = oSettings.value("txtcolor", QColor(0,0,0)).value<QColor>();
    int bgcoloralpha = oSettings.value("bgcoloralpha", int(180)).toInt();
    cldefault.setAlpha(bgcoloralpha);



    QPalette pal = this->palette();
    this->setAttribute(Qt::WA_TranslucentBackground);
    this->setAttribute(Qt::WA_NoSystemBackground, false);

    pal.setColor(QPalette::Window, cldefault);
    this->setPalette(pal);
    this->ensurePolished(); // workaround Oxygen filling the background
    this->setAttribute(Qt::WA_StyledBackground, false);




    QSize oMovSize;
    oMovSize.setHeight(21);
    oMovSize.setWidth(21);
    ui->lbicon->setText("");
    QMovie *movie = new QMovie(":/img/res/pin.png");
    movie->setScaledSize(oMovSize);
    movie->setBackgroundColor(Qt::transparent);
    ui->lbicon->setMovie(movie);
    ui->lbicon->show();
    movie->start();



    ui->teMain->setFrameShadow(QFrame::Plain);
    ui->teMain->setFrameShape(QFrame::NoFrame);
    ui->teMain->setPalette(QPalette(cltextedit,cldefault,cldefault,cltextedit,cltextedit,cltextedit,cldefault,cldefault,cldefault));
    ui->teMain->setFontFamily("Nokia Sans SemiBold");
    ui->teMain->setFontPointSize(8);
    ui->teMain->setWordWrapMode(QTextOption::WrapAtWordBoundaryOrAnywhere);
    ui->teMain->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->teMain->setReadOnly(true);

    ui->teMain->setStyleSheet( "background-color: rgba( 255, 255, 0, 0% );" );



    ui->lblDate->setLayoutDirection(Qt::RightToLeft);
    ui->lblDate->setPalette(QPalette(cllabelcolor,cllabelcolor,cllabelcolor,cllabelcolor,cllabelcolor,cllabelcolor,cldefault,cldefault,cldefault));
    ui->lblDate->setFont(QFont("Nokia Sans SemiBold",10,10));


    QPalette p = palette();
    ui->pbEdit->setPalette(p);
    ui->pbEdit->setStyleSheet( "background-color: rgba( 255, 255, 255, 0% );" );
    ui->pbEdit->setText("");
    ui->pbEdit->setFlat(true);


#ifdef Q_WS_HILDON
       this->setProperty("FingerScrollable", true);
       this->setFocusPolicy(Qt::StrongFocus);
       ui->teMain->setFocusPolicy(Qt::StrongFocus);
       ui->teMain->setProperty("FingerScrollable", true);
#endif

   ui->teMain->setText(oSettings.value("note","").toString());
   ui->lblDate->setText(oSettings.value("notedate",QDateTime::currentDateTime().toString("dd.MM.yyyy   HH:mm")).toString());

   ui->centralWidget->repaint();
   this->repaint();

}



MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}




void MainWindow::on_pbEdit_clicked()
{
    SetupThisUi();
    Dialog w(0);
    w.exec();
    QSettings oSettings("janbergmann", "simplenotewidget");
    ui->teMain->setText(oSettings.value("note","").toString());
    ui->lblDate->setText(oSettings.value("notedate",QDateTime::currentDateTime().toString("dd.MM.yyyy   HH:mm")).toString());
}
