#include "dialog.h"
#include "ui_dialog.h"
#include <QFile>
#include <QXmlStreamWriter>
#include <QDateTime>
#include <QDir>
#include <QSettings>





Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);


#ifdef Q_WS_HILDON
  this->setProperty("FingerScrollable", true);
  ui->pbOK->setProperty("FingerScrollable", true);
#endif

  QSettings oSettings("janbergmann", "simplenotewidget");
  QColor cldefault = oSettings.value("bgcolor", QColor(255,255,0)).value<QColor>();
  QColor cllabelcolor = oSettings.value("lblcolor", QColor(0,0,0)).value<QColor>();
  QColor cltextedit = oSettings.value("txtcolor", QColor(0,0,0)).value<QColor>();
  int bgcoloralpha = oSettings.value("bgcoloralpha", int(180)).toInt();
  cldefault.setAlpha(bgcoloralpha);



    //QColor cldefault(255,255,0);
    //QColor cltextedit(0,0,0);


    this->setWindowTitle("Edit note");

    this->setWindowModality(Qt::ApplicationModal);



    ui->teMain->setFrameShadow(QFrame::Plain);
    ui->teMain->setFrameShape(QFrame::NoFrame);
    ui->teMain->setPalette(QPalette(cltextedit,cldefault,cldefault,cltextedit,cltextedit,cltextedit,cldefault,cldefault,cldefault));
    ui->teMain->setFontFamily("Nokia Sans SemiBold");
    ui->teMain->setFontPointSize(8);
    ui->teMain->setWordWrapMode(QTextOption::WrapAtWordBoundaryOrAnywhere);
    ui->teMain->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);



    ui->teMain->setText(oSettings.value("note","").toString());



}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Dialog::on_pbOK_clicked()
{
    QDateTime dateTime = QDateTime::currentDateTime();
    QString dateTimeString = dateTime.toString("dd.MM.yyyy   HH:mm");

    QSettings oSettings("janbergmann", "simplenotewidget");
    oSettings.setValue("note",ui->teMain->toPlainText());
    oSettings.setValue("notedate",dateTimeString);


    this->close();
}

void Dialog::on_pbCancel_clicked()
{
    this->close();
}
